/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStopCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutdownCommand
extends AbstractStopCommand {
    private static final L10N L = new L10N(ShutdownCommand.class);
    private static final Logger log = Logger.getLogger(ShutdownCommand.class.getName());

    @Override
    public String getDescription() {
        return "shuts down the watchdog and all its managed Resin servers";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.shutdown();
            System.out.println(L.l("Resin/{0} shutdown watchdog at {1}:{2}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            System.out.println(L.l("Resin/{0} can't shutdown watchdog at {1}:{2}.\n{3}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)e.toString()));
            log.log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    @Override
    public boolean isRetry() {
        return true;
    }
}

