/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;

class WatchdogManagerConfig {
    private static final L10N L = new L10N(WatchdogManagerConfig.class);
    private ResinSystem _system;
    private BootResinConfig _resin;
    private ArrayList<ContainerProgram> _watchdogDefaultList = new ArrayList();

    WatchdogManagerConfig(ResinSystem system, BootResinConfig resin) {
        this._system = system;
        this._resin = resin;
    }

    public void setWatchdogPort(int watchdogPort) {
        if (this._resin.getArgs().getWatchdogPort() == 0) {
            this._resin.getArgs().setWatchdogPort(watchdogPort);
        }
    }

    public void addWatchdogDefault(ContainerProgram program) {
        this._watchdogDefaultList.add(program);
    }

    public WatchdogConfig createWatchdog() {
        BootClusterConfig cluster = null;
        WatchdogConfig config = new WatchdogConfig("", cluster, this._resin.getArgs(), this._resin.getRootDirectory(), this._resin.getNextIndex());
        for (int i = 0; i < this._watchdogDefaultList.size(); ++i) {
            this._watchdogDefaultList.get(i).configure(config);
        }
        return config;
    }

    public void addWatchdog(WatchdogConfig config) throws ConfigException {
        if (this._resin.findClient(config.getId()) != null) {
            throw new ConfigException(L.l("<server id='{0}'> is a duplicate server.  servers must have unique ids.", (Object)config.getId()));
        }
        this._resin.addClient(new WatchdogClient(this._system, this._resin, config));
    }
}

