/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.cfg.ApplicationScopedLiteral;
import com.caucho.config.cfg.ConversationScopedLiteral;
import com.caucho.config.cfg.DependentLiteral;
import com.caucho.config.cfg.RequestScopedLiteral;
import com.caucho.config.cfg.SessionScopedLiteral;
import com.caucho.config.cfg.SingletonLiteral;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Qualifier;
import javax.naming.NamingException;

public abstract class AbstractBeanConfig {
    private static final L10N L = new L10N(AbstractBeanConfig.class);
    private String _filename;
    private int _line;
    private String _name;
    private String _jndiName;
    private Class<?> _cl;
    private ArrayList<Annotation> _annotations = new ArrayList();
    private ArrayList<Annotation> _qualifiers = new ArrayList();
    private ArrayList<Annotation> _stereotypes = new ArrayList();
    private Class<? extends Annotation> _scope;
    private ContainerProgram _init;

    protected AbstractBeanConfig() {
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setClass(Class<?> cl) {
        this._cl = cl;
    }

    public Class<?> getInstanceClass() {
        return this._cl;
    }

    public void addBinding(Annotation binding) {
        this._annotations.add(binding);
    }

    public void add(Annotation binding) {
        this._annotations.add(binding);
        if (binding.annotationType().isAnnotationPresent(Qualifier.class)) {
            this._qualifiers.add(binding);
        }
    }

    public void add(Bean bean) {
        System.out.println("Bean: " + bean);
    }

    public void setScope(String scope) {
        if ("singleton".equals(scope)) {
            this.add((Annotation)SingletonLiteral.ANN);
        } else if ("dependent".equals(scope)) {
            this.add((Annotation)DependentLiteral.ANN);
        } else if ("request".equals(scope)) {
            this.add((Annotation)RequestScopedLiteral.ANN);
        } else if ("session".equals(scope)) {
            this.add((Annotation)SessionScopedLiteral.ANN);
        } else if ("application".equals(scope)) {
            this.add((Annotation)ApplicationScopedLiteral.ANN);
        } else if ("conversation".equals(scope)) {
            this.add((Annotation)ConversationScopedLiteral.ANN);
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid scope.  The scope must be a valid @Scope annotation."));
        }
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    protected void initImpl() {
    }

    @PostConstruct
    public final void init() {
        this.initImpl();
        if (this._cl == null) {
            throw new ConfigException(L.l("{0} requires a 'class' attribute", (Object)this.getClass().getSimpleName()));
        }
    }

    protected <X> void deploy() {
        InjectManager beanManager = InjectManager.create();
        AnnotatedTypeImpl<X> beanType = this.buildAnnotatedType();
        BeanBuilder<X> builder = beanManager.createBeanFactory(beanType);
        if (this._scope != null) {
            builder.scope(this._scope);
        }
        if (this._init != null) {
            builder.init(this._init);
        }
        for (Annotation qualifier : this._qualifiers) {
            builder.qualifier(qualifier);
        }
        Object value = this.replaceObject();
        Bean<X> bean = null;
        if (value != null) {
            bean = builder.singleton(value);
            beanManager.addBeanDiscover(bean);
        } else {
            bean = builder.bean();
            beanManager.addBeanDiscover(bean);
        }
        if (this._jndiName != null) {
            try {
                Jndi.bindDeepShort(this._jndiName, bean);
            }
            catch (NamingException e) {
                throw ConfigException.create(e);
            }
        }
    }

    protected <X> AnnotatedTypeImpl<X> buildAnnotatedType() {
        InjectManager beanManager = InjectManager.create();
        ReflectionAnnotatedType<?> annType = ReflectionAnnotatedFactory.introspectType(this._cl);
        AnnotatedTypeImpl beanType = new AnnotatedTypeImpl((AnnotatedType<?>)annType);
        if (this._name != null) {
            beanType.addAnnotation((Annotation)Names.create(this._name));
        }
        for (Annotation binding : this._qualifiers) {
            beanType.addAnnotation(binding);
        }
        for (Annotation stereotype : this._stereotypes) {
            beanType.addAnnotation(stereotype);
        }
        for (Annotation ann : this._annotations) {
            beanType.addAnnotation(ann);
        }
        return beanType;
    }

    protected Object replaceObject() {
        return null;
    }
}

