/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.event.ObserverEntry;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.ObserverMethod;

@Module
public class ObserverMap {
    private static final Logger log = Logger.getLogger(ObserverMap.class.getName());
    private Class<?> _type;
    private ArrayList<ObserverEntry<?>> _observerList = new ArrayList();

    public ObserverMap(Class<?> type) {
        this._type = type;
    }

    public void addObserver(ObserverMethod<?> observer, BaseType type, Annotation[] bindings) {
        ObserverEntry entry = new ObserverEntry(observer, type, bindings);
        this._observerList.add(entry);
    }

    public <T> void resolveObservers(Set<ObserverMethod<? super T>> set, BaseType eventType, Annotation[] qualifiers) {
        for (int i = 0; i < this._observerList.size(); ++i) {
            ObserverEntry<?> observer = this._observerList.get(i);
            if (!observer.isAssignableFrom(eventType, qualifiers)) continue;
            set.add(observer.getObserver());
        }
    }

    public void resolveEntries(ArrayList<ObserverEntry<?>> list, BaseType eventType, BaseType subType) {
        for (int i = 0; i < this._observerList.size(); ++i) {
            ObserverEntry<?> observer = this._observerList.get(i);
            BaseType observerType = observer.getType();
            if (!observerType.isAssignableFrom(eventType) && !observerType.isAssignableFrom(subType) || list.contains(observer)) continue;
            list.add(observer);
        }
    }

    public void fireEvent(Object event, BaseType eventType, Annotation[] qualifiers) {
        for (int i = 0; i < this._observerList.size(); ++i) {
            ObserverEntry<?> observer = this._observerList.get(i);
            if (!observer.isAssignableFrom(eventType, qualifiers)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(observer.getObserver() + " notify " + event);
            }
            observer.notify(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

