/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.inject.Module;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;

@Module
public class PreDestroyInject
extends ConfigProgram {
    private static final Logger log = Logger.getLogger(PreDestroyInject.class.getName());
    private Method _destroy;

    public PreDestroyInject(Method destroy) {
        this._destroy = destroy;
        this._destroy.setAccessible(true);
    }

    @Override
    public <T> void inject(T value, CreationalContext<T> env) throws ConfigException {
        try {
            this._destroy.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._destroy + "]";
    }
}

