/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class FloatType
extends ConfigType {
    private static final L10N L = new L10N(FloatType.class);
    public static final FloatType TYPE = new FloatType();
    private static final Float ZERO = new Float(0.0f);

    private FloatType() {
    }

    public Class getType() {
        return Float.class;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Float.valueOf(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Float) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to an Float", value));
    }
}

