/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class BetweenExpr
extends Expr {
    private Expr _expr;
    private Expr _min;
    private Expr _max;
    private boolean _isNot;
    private boolean _isLong;

    BetweenExpr(Expr expr, Expr min, Expr max, boolean isNot) {
        this._expr = expr;
        this._min = min;
        this._max = max;
        this._isNot = isNot;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        this._min = this._min.bind(query);
        this._max = this._max.bind(query);
        this._isLong = this._expr.isLong();
        return this;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._expr.subCost(fromList) + this._min.subCost(fromList) + this._max.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return -1;
        }
        if (this._isLong) {
            long min = this._min.evalLong(context);
            long max = this._max.evalLong(context);
            long value = this._expr.evalLong(context);
            if (this._isNot) {
                return min > value || value > max ? 1 : 0;
            }
            return min <= value && value <= max ? 1 : 0;
        }
        double min = this._min.evalDouble(context);
        double max = this._max.evalDouble(context);
        double value = this._expr.evalDouble(context);
        if (this._isNot) {
            return !(min <= value) || !(value <= max) ? 1 : 0;
        }
        return min <= value && value <= max ? 1 : 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._expr.evalGroup(context);
        this._min.evalGroup(context);
        this._max.evalGroup(context);
    }

    public String toString() {
        return "(" + this._expr + " BETWEEN " + this._min + " AND " + this._max + ")";
    }
}

