/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.table.Column;
import com.caucho.util.QDate;
import java.io.InputStream;

public class Data {
    private Column _column;
    private Column.ColumnType _type = Column.ColumnType.NONE;
    private boolean _booleanData;
    private String _stringData;
    private int _intData;
    private long _longData;
    private double _doubleData;
    private InputStream _binaryStream;
    private int _streamLength;
    private byte[] _bytes;

    public void clear() {
        this._type = Column.ColumnType.NONE;
    }

    public void setColumn(Column column) {
        this._column = column;
    }

    public Column getColumn() {
        return this._column;
    }

    public Column.ColumnType getType() {
        return this._type;
    }

    public boolean isNull() {
        return this._type == Column.ColumnType.NONE;
    }

    public void setString(String value) {
        if (value == null) {
            this._type = Column.ColumnType.NONE;
        } else {
            this._type = Column.ColumnType.VARCHAR;
            this._stringData = value;
        }
    }

    public void setDate(long value) {
        this._type = Column.ColumnType.DATE;
        this._longData = value;
    }

    public boolean isBinaryStream() {
        return this._type == Column.ColumnType.BLOB;
    }

    public void setBinaryStream(InputStream is, int length) {
        this._type = Column.ColumnType.BLOB;
        this._binaryStream = is;
        this._streamLength = length;
    }

    public InputStream getBinaryStream() {
        switch (this._type) {
            case NONE: {
                return null;
            }
            case BLOB: {
                return this._binaryStream;
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this._type));
    }

    public void setBytes(byte[] bytes) {
        this._type = Column.ColumnType.BINARY;
        this._bytes = bytes;
    }

    public byte[] getBytes() {
        switch (this._type) {
            case NONE: {
                return null;
            }
            case BINARY: {
                return this._bytes;
            }
            case VARCHAR: {
                return this._stringData.getBytes();
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this._type) + " " + this.toString());
    }

    public String getString() {
        switch (this._type) {
            case NONE: {
                return null;
            }
            case BOOLEAN: {
                return this._booleanData ? "true" : "false";
            }
            case INT: {
                return String.valueOf(this._intData);
            }
            case LONG: {
                return String.valueOf(this._longData);
            }
            case DOUBLE: {
                return String.valueOf(this._doubleData);
            }
            case VARCHAR: {
                return this._stringData;
            }
            case DATE: {
                return QDate.formatISO8601(this._longData);
            }
            case BINARY: {
                StringBuilder sb = new StringBuilder();
                int len = this._bytes.length;
                for (int i = 0; i < len; ++i) {
                    sb.append((char)(this._bytes[i] & 0xFF));
                }
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this._type));
    }

    public void setBoolean(boolean value) {
        this._type = Column.ColumnType.BOOLEAN;
        this._booleanData = value;
    }

    public int getBoolean() {
        switch (this._type) {
            case NONE: {
                return -1;
            }
            case BOOLEAN: {
                return this._booleanData ? 1 : 0;
            }
            case INT: {
                return this._intData != 0 ? 1 : 0;
            }
            case LONG: {
                return this._longData != 0L ? 1 : 0;
            }
            case DOUBLE: {
                return this._doubleData != 0.0 ? 1 : 0;
            }
            case VARCHAR: {
                return this._stringData.equalsIgnoreCase("y") ? 1 : 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setInt(int value) {
        this._type = Column.ColumnType.INT;
        this._intData = value;
    }

    public int getInt() {
        switch (this._type) {
            case NONE: {
                return 0;
            }
            case BOOLEAN: {
                return this._booleanData ? 1 : 0;
            }
            case INT: {
                return this._intData;
            }
            case LONG: {
                return (int)this._longData;
            }
            case DOUBLE: {
                return (int)this._doubleData;
            }
            case VARCHAR: {
                return Integer.parseInt(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setLong(long value) {
        this._type = Column.ColumnType.LONG;
        this._longData = value;
    }

    public long getLong() {
        switch (this._type) {
            case NONE: {
                return 0L;
            }
            case BOOLEAN: {
                return this._booleanData ? 1L : 0L;
            }
            case INT: {
                return this._intData;
            }
            case LONG: {
                return this._longData;
            }
            case DOUBLE: {
                return (long)this._doubleData;
            }
            case VARCHAR: {
                return Long.parseLong(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public long getDate() {
        switch (this._type) {
            case NONE: {
                return 0L;
            }
            case BOOLEAN: {
                return this._booleanData ? 1L : 0L;
            }
            case INT: {
                return this._intData;
            }
            case LONG: {
                return this._longData;
            }
            case DOUBLE: {
                return (long)this._doubleData;
            }
            case VARCHAR: {
                return Long.parseLong(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setDouble(double value) {
        this._type = Column.ColumnType.DOUBLE;
        this._doubleData = value;
    }

    public double getDouble() {
        if (this._type == null) {
            return 0.0;
        }
        switch (this._type) {
            case NONE: {
                return 0.0;
            }
            case BOOLEAN: {
                return this._booleanData ? 1.0 : 0.0;
            }
            case INT: {
                return this._intData;
            }
            case LONG: {
                return this._longData;
            }
            case DOUBLE: {
                return this._doubleData;
            }
            case VARCHAR: {
                return Double.parseDouble(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void copyTo(Data dst) {
        switch (this._type) {
            case NONE: {
                dst.setString(null);
                break;
            }
            case BOOLEAN: {
                dst.setBoolean(this._booleanData);
                break;
            }
            case INT: {
                dst.setInt(this._intData);
                break;
            }
            case LONG: {
                dst.setLong(this._longData);
                break;
            }
            case DOUBLE: {
                dst.setDouble(this._doubleData);
                break;
            }
            case VARCHAR: {
                dst.setString(this._stringData);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int hashCode() {
        switch (this._type) {
            case NONE: {
                return 17;
            }
            case BOOLEAN: {
                return this._booleanData ? 1 : 0;
            }
            case INT: {
                return this._intData;
            }
            case LONG: {
                return (int)this._longData;
            }
            case DOUBLE: {
                return (int)this._doubleData;
            }
            case VARCHAR: {
                return this._stringData.hashCode();
            }
        }
        return 97;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Data data = (Data)o;
        if (this._type != data._type) {
            return false;
        }
        switch (this._type) {
            case NONE: {
                return false;
            }
            case BOOLEAN: {
                return this._booleanData == data._booleanData;
            }
            case INT: {
                return this._intData == data._intData;
            }
            case LONG: {
                return this._longData == data._longData;
            }
            case DOUBLE: {
                return this._doubleData == data._doubleData;
            }
            case VARCHAR: {
                return this._stringData.equals(data._stringData);
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getString() + "]";
    }
}

