/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.LifecycleAspectBeanFactory;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.ejb.gen.MessageAspectBeanFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class MessageGenerator<X>
extends BeanGenerator<X> {
    private AspectBeanFactory<X> _aspectBeanFactory;
    private ArrayList<AspectGenerator<X>> _businessMethods = new ArrayList();
    private ArrayList<AnnotatedMethod<? super X>> _annotatedMethods = new ArrayList();
    private final AspectBeanFactory<X> _lifecycleAspectFactory;

    public MessageGenerator(String ejbName, AnnotatedType<X> ejbClass) {
        super(MessageGenerator.toFullClassName(ejbName, ejbClass.getJavaClass().getName()), ejbClass);
        InjectManager manager = InjectManager.create();
        this._aspectBeanFactory = new MessageAspectBeanFactory(manager, this.getBeanType());
        this._lifecycleAspectFactory = new LifecycleAspectBeanFactory<X>(this._aspectBeanFactory, manager, this.getBeanType());
    }

    @Override
    protected AspectBeanFactory<X> getLifecycleAspectFactory() {
        return this._lifecycleAspectFactory;
    }

    private static String toFullClassName(String ejbName, String className) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append("__MessageProxy");
        return sb.toString();
    }

    public String getContextClassName() {
        return this.getClassName();
    }

    @Override
    public String getViewClassName() {
        return this.getClassName();
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectBeanFactory;
    }

    @Override
    public ArrayList<AspectGenerator<X>> getMethods() {
        return this._businessMethods;
    }

    @Override
    public void introspect() {
        super.introspect();
        this.introspectType(this.getBeanType());
        this.introspectImpl();
    }

    private void introspectType(AnnotatedType<? super X> type) {
        for (AnnotatedMethod method : type.getMethods()) {
            this.introspectMethod(method);
        }
    }

    private void introspectMethod(AnnotatedMethod<? super X> method) {
        this._annotatedMethods.add(method);
    }

    private void introspectImpl() {
        for (AnnotatedMethod<? super X> annotatedMethod : this._annotatedMethods) {
            this.introspectMethodImpl(annotatedMethod);
        }
    }

    private void introspectMethodImpl(AnnotatedMethod<? super X> apiMethod) {
        Method javaMethod = apiMethod.getJavaMember();
        if (javaMethod.getDeclaringClass().equals(Object.class)) {
            return;
        }
        if (javaMethod.getDeclaringClass().getName().startsWith("javax.ejb.")) {
            return;
        }
        int modifiers = javaMethod.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) {
            return;
        }
        if (apiMethod.isAnnotationPresent(PostConstruct.class)) {
            this.addLifecycleMethod(apiMethod);
        } else {
            this.addBusinessMethod(apiMethod);
        }
    }

    public void addBusinessMethod(AnnotatedMethod<? super X> method) {
        AspectGenerator<? super X> bizMethod = this._aspectBeanFactory.create(method);
        if (bizMethod != null) {
            this._businessMethods.add(bizMethod);
        }
    }

    protected void addLifecycleMethod(AnnotatedMethod<? super X> method) {
        if (this.getLifecycleAspectFactory() == null) {
            return;
        }
        AspectGenerator<? super X> initMethod = this.getLifecycleAspectFactory().create(method);
        if (initMethod != null && !this._businessMethods.contains(initMethod)) {
            this._businessMethods.add(initMethod);
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.message.*;");
        out.println();
        out.println("import java.util.*;");
        out.println("import java.lang.reflect.*;");
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        out.println("import javax.transaction.xa.*;");
        out.println("import javax.resource.spi.endpoint.*;");
        out.println();
        out.println("public class " + this.getClassName() + " extends " + this.getBeanType().getJavaClass().getName() + " implements MessageEndpoint, CauchoMessageEndpoint");
        out.println("{");
        out.pushDepth();
        out.println("private static HashSet<Method> _xaMethods = new HashSet<Method>();");
        out.println();
        out.println("private MessageManager _server;");
        out.println("private XAResource _xaResource;");
        out.println("private boolean _isXa;");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caucho.ejb.xa", "true");
        this.generateBeanPrologue(out, map);
        out.println();
        out.println("public " + this.getClassName() + "()");
        out.println("{");
        out.pushDepth();
        this.generateBeanConstructor(out);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        for (AspectGenerator<X> bizMethod : this.getMethods()) {
            AnnotatedMethod<X> method = bizMethod.getMethod();
            TransactionAttribute xa = (TransactionAttribute)method.getAnnotation(TransactionAttribute.class);
            if (xa == null) {
                xa = (TransactionAttribute)method.getDeclaringType().getAnnotation(TransactionAttribute.class);
            }
            if (xa == null || !TransactionAttributeType.REQUIRED.equals((Object)xa.value())) continue;
            this.addXaMethods(out, method.getJavaMember());
        }
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setXAResource(XAResource xaResource)");
        out.println("{");
        out.println("  _xaResource = xaResource;");
        out.println("}");
        out.println();
        out.println("public void beforeDelivery(java.lang.reflect.Method method)");
        out.println("{");
        out.println("  if (_xaMethods.contains(method)) {");
        out.println("    _isXa = (_xa.beginRequired() == null);");
        out.println();
        out.println("    if (_isXa && _xaResource != null)");
        out.println("      _xa.enlist(_xaResource);");
        out.println("  }");
        out.println("}");
        out.println("public void afterDelivery()");
        out.println("{");
        out.println("  if (_isXa) {");
        out.println("    _isXa = false;");
        out.println("    _xa.commit();");
        out.println("  }");
        out.println("}");
        out.println();
        out.println("public void release()");
        out.println("{");
        out.pushDepth();
        if (this.getImplMethod("ejbRemove", new Class[0]) != null) {
            out.println("ejbRemove();");
        }
        out.popDepth();
        out.println("}");
        this.generateView(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    private void addXaMethods(JavaWriter out, Method method) throws IOException {
        this.printXaMethod(out, method);
        for (Class<?> api : method.getDeclaringClass().getInterfaces()) {
            Method subMethod = AnnotatedTypeUtil.findMethod(api.getMethods(), method);
            if (subMethod == null) continue;
            this.printXaMethod(out, subMethod);
        }
    }

    private void printXaMethod(JavaWriter out, Method api) throws IOException {
        out.print("_xaMethods.add(");
        out.printClass(api.getDeclaringClass());
        out.print(".class.getMethod(\"");
        out.print(api.getName());
        out.print("\", new Class[] { ");
        for (Class<?> cl : api.getParameterTypes()) {
            out.printClass(cl);
            out.print(".class, ");
        }
        out.println("}));");
    }

    private void generateView(JavaWriter out) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caucho.ejb.xa", "done");
        out.println();
        out.println("private static final com.caucho.ejb.util.XAManager _xa");
        out.println("  = new com.caucho.ejb.util.XAManager();");
        for (AspectGenerator<X> bizMethod : this._businessMethods) {
            bizMethod.generate(out, map);
        }
        this.generatePostConstruct(out, map);
    }

    private AnnotatedMethod<? super X> getImplMethod(String name, Class<?>[] param) {
        return AnnotatedTypeUtil.findMethod(this.getBeanType(), name, param);
    }
}

