/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor2;

import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor2.ArrayRing;
import com.caucho.env.actor2.ArrayRingAtomic;
import com.caucho.env.actor2.QueueRingBase;
import com.caucho.env.actor2.RingBlocker;
import com.caucho.env.actor2.RingBlockerBasic;
import com.caucho.util.L10N;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class QueueRingFixed<M>
extends QueueRingBase<M> {
    private static final L10N L = new L10N(QueueRingFixed.class);
    private final ArrayRing<M> _ring;
    private final int _capacity;
    private final AtomicLong _head;
    private final AtomicLong _tail;
    private final RingBlocker _blocker;
    private volatile boolean _isWriteClosed;

    public QueueRingFixed(int capacity) {
        this(capacity, new RingBlockerBasic());
    }

    public QueueRingFixed(int capacity, RingBlocker blocker) {
        if (Integer.bitCount(capacity) != 1 || capacity < 2) {
            throw new IllegalArgumentException(L.l("Invalid ring capacity {0}", (Object)Long.toHexString(capacity)));
        }
        if (blocker == null) {
            throw new NullPointerException(L.l("RingBlocker is required"));
        }
        this._capacity = capacity;
        ArrayRingAtomic ring = null;
        if (ring == null) {
            ring = new ArrayRingAtomic(capacity);
        }
        this._ring = ring;
        this._head = new AtomicLong();
        this._tail = new AtomicLong();
        this._blocker = blocker;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public final boolean isEmpty() {
        return this._head.get() == this._tail.get();
    }

    @Override
    public final int size() {
        long head = this._head.get();
        long tail = this._tail.get();
        return (int)(head - tail);
    }

    @Override
    public int remainingCapacity() {
        return this.getCapacity() - this.size() - 1;
    }

    @Override
    public final long head() {
        return this._head.get();
    }

    public final long getHeadAlloc() {
        return this._head.get();
    }

    public final long getTail() {
        return this._tail.get();
    }

    public final long getTailAlloc() {
        return this._tail.get();
    }

    @Override
    public void wake() {
        this._blocker.offerWake();
    }

    public final M getValue(long ptr) {
        return this.get(ptr);
    }

    private final M get(long ptr) {
        return this._ring.get(ptr);
    }

    @Override
    public final boolean offer(M value, long timeout, TimeUnit unit) {
        long head;
        if (value == null) {
            throw new NullPointerException();
        }
        AtomicLong headRef = this._head;
        AtomicLong tailRef = this._tail;
        int capacity = this._capacity;
        while (true) {
            long tail = tailRef.get();
            head = headRef.get();
            long nextHead = head + 1L;
            if ((long)capacity <= nextHead - tail) {
                long sequence = this._blocker.nextOfferSequence();
                if ((long)capacity > headRef.get() + 1L - tailRef.get() || this._blocker.offerWait(sequence, timeout, unit)) continue;
                return false;
            }
            if (headRef.compareAndSet(head, nextHead)) break;
        }
        this._ring.set(head, value);
        return true;
    }

    @Override
    public final M poll(long timeout, TimeUnit unit) {
        AtomicLong headRef = this._head;
        AtomicLong tailRef = this._tail;
        ArrayRing<M> ring = this._ring;
        RingBlocker blocker = this._blocker;
        while (true) {
            long head;
            long tail;
            if ((tail = tailRef.get()) == (head = headRef.get())) {
                blocker.offerWake();
                if (timeout <= 0L) {
                    return null;
                }
                long pollSequence = blocker.nextPollSequence();
                if (tailRef.get() != headRef.get() || blocker.pollWait(pollSequence, timeout, unit)) continue;
                return null;
            }
            M value = ring.pollAndClear(tail);
            if (value == null) continue;
            if (tailRef.compareAndSet(tail, tail + 1L)) {
                blocker.offerWake();
                return value;
            }
            ring.set(tail, value);
        }
    }

    @Override
    public final M peek() {
        long head = this._head.get();
        long tailAlloc = this._tail.get();
        if (tailAlloc < head) {
            return this.get(tailAlloc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(ActorProcessor<? super M> deliver) throws Exception {
        long tail;
        int tailChunk = 64;
        ArrayRing<M> ring = this._ring;
        AtomicLong headRef = this._head;
        AtomicLong tailRef = this._tail;
        long head = headRef.get();
        long lastTail = tail = tailRef.get();
        try {
            while (tail < head) {
                long tailChunkEnd = Math.min(head, tail + 64L);
                while (tail < tailChunkEnd) {
                    M item = ring.takeAndClear(tail);
                    ++tail;
                    deliver.process(item);
                }
                tailRef.set(tail);
                lastTail = tail;
                this._blocker.offerWake();
                head = headRef.get();
            }
        }
        finally {
            if (tail != lastTail) {
                tailRef.set(tail);
            }
            this._blocker.offerWake();
        }
    }

    public final boolean isWriteClosed() {
        return this._isWriteClosed;
    }

    public final void pollWake() {
        this._blocker.pollWake();
    }

    public final void closeWrite() {
        this._isWriteClosed = true;
        this._blocker.offerWake();
        this._blocker.pollWake();
    }

    public final void shutdown() {
        this.closeWrite();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getCapacity() + "]";
    }
}

