/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.HashMap;
import java.util.Map;

public class CommitBuilder {
    private static final L10N L = new L10N(CommitBuilder.class);
    private String _stage = "production";
    private String _type;
    private String _tagKey;
    private String _version;
    private Map<String, String> _attributes = new HashMap<String, String>();
    private long _date;
    private String _timestamp;

    public CommitBuilder stage(String stage) {
        if (stage.isEmpty()) {
            throw new IllegalArgumentException(L.l("{0} stage must not be empty", (Object)this));
        }
        this._stage = stage;
        return this;
    }

    public String getStage() {
        return this._stage;
    }

    public CommitBuilder type(String type) {
        if (type.isEmpty()) {
            throw new IllegalArgumentException(L.l("{0} type must not be empty", (Object)type));
        }
        this._type = type;
        return this;
    }

    public String getType() {
        return this._type;
    }

    public CommitBuilder tagKey(String key) {
        this._tagKey = key;
        return this;
    }

    public String getTagKey() {
        return this._tagKey;
    }

    public CommitBuilder version(int major, int minor, int micro, String qualifier) {
        this._version = qualifier != null && !qualifier.isEmpty() ? major + "." + minor + "." + micro + "." + qualifier : major + "." + minor + "." + micro;
        this.attribute("version", this._version);
        return this;
    }

    public String getVersion() {
        return this._version;
    }

    public CommitBuilder message(String message) {
        return this.attribute("message", message);
    }

    public CommitBuilder attribute(String key, String value) {
        this._attributes.put(key, value);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    public String getId() {
        String stage = this.getStage();
        String type = this.getType();
        String key = this.getTagKey();
        String version = this.getVersion();
        if (type == null) {
            throw new IllegalStateException(L.l("{0} requires a non-empty type", (Object)this));
        }
        if (key == null) {
            throw new IllegalStateException(L.l("{0} requires a non-empty key", (Object)this));
        }
        if (version != null) {
            return stage + "/" + type + "/" + key + "-" + version;
        }
        return stage + "/" + type + "/" + key;
    }

    public String getArchiveId() {
        String type = this.getType();
        String key = this.getTagKey();
        String version = this.getVersion();
        if (type == null) {
            throw new IllegalStateException(L.l("{0} requires a non-empty type", (Object)this));
        }
        if (key == null) {
            throw new IllegalStateException(L.l("{0} requires a non-empty key", (Object)this));
        }
        if (this._timestamp == null) {
            throw new IllegalStateException(L.l("{0} requires an active timestamp", (Object)this));
        }
        if (version != null) {
            return "archive/" + type + "/" + key + "-" + version + "/" + this._timestamp;
        }
        return "archive/" + type + "/" + key + "/" + this._timestamp;
    }

    public void validate() {
        if (this.getId() == null) {
            throw new IllegalStateException(L.l("{0} requires a non-empty id", (Object)this));
        }
        if (this._date == 0L) {
            this._date = CurrentTime.getCurrentTime();
        }
        QDate qDate = QDate.allocateLocalDate();
        qDate.setGMTTime(this._date);
        this._timestamp = qDate.printISO8601();
        QDate.freeLocalDate(qDate);
        this._attributes.put("date", this._timestamp);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

