/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.service;

import com.caucho.config.ConfigException;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.java.WorkDir;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootDirectorySystem
extends AbstractResinSubSystem {
    private static final Logger log = Logger.getLogger(RootDirectorySystem.class.getName());
    public static final int START_PRIORITY_ROOT_DIRECTORY = 20;
    private static final L10N L = new L10N(RootDirectorySystem.class);
    private final Path _rootDirectory;
    private final Path _dataDirectory;
    private FileOutputStream _foutLock;
    private FileLock _fileLock;
    private boolean _isIgnoreLock;

    public RootDirectorySystem(Path rootDirectory, Path dataDirectory) throws IOException {
        if (rootDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory instanceof MemoryPath) {
            dataDirectory = WorkDir.getTmpWorkDir().lookup("qa/" + dataDirectory.getFullPath());
        }
        this._rootDirectory = rootDirectory;
        this._dataDirectory = dataDirectory;
        rootDirectory.mkdirs();
        dataDirectory.mkdirs();
    }

    public static RootDirectorySystem createAndAddService(Path rootDirectory) throws IOException {
        return RootDirectorySystem.createAndAddService(rootDirectory, rootDirectory.lookup("resin-data"));
    }

    public static RootDirectorySystem createAndAddService(Path rootDirectory, Path dataDirectory) throws IOException {
        ResinSystem system = RootDirectorySystem.preCreate(RootDirectorySystem.class);
        RootDirectorySystem service = new RootDirectorySystem(rootDirectory, dataDirectory);
        system.addService(RootDirectorySystem.class, service);
        return service;
    }

    public static RootDirectorySystem getCurrent() {
        return ResinSystem.getCurrentService(RootDirectorySystem.class);
    }

    public static Path getCurrentDataDirectory() {
        RootDirectorySystem rootService = RootDirectorySystem.getCurrent();
        if (rootService == null) {
            throw new IllegalStateException(L.l("{0} must be active for getCurrentDataDirectory().", (Object)RootDirectorySystem.class.getSimpleName()));
        }
        return rootService.getDataDirectory();
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getDataDirectory() {
        return this._dataDirectory;
    }

    public void setIgnoreLock(boolean isIgnoreLock) {
        this._isIgnoreLock = isIgnoreLock;
    }

    @Override
    public int getStartPriority() {
        return 20;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this._isIgnoreLock) {
            return;
        }
        Path lockPath = this.getDataDirectory().lookup("resin.lock");
        try {
            File file = new File(lockPath.getNativePath());
            this._foutLock = new FileOutputStream(file);
            try {
                long timeout = 60000L;
                long expires = CurrentTime.getCurrentTimeActual() + timeout;
                while (CurrentTime.getCurrentTimeActual() < expires && this._fileLock == null) {
                    this._fileLock = this._foutLock.getChannel().tryLock();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                if (this._fileLock == null) {
                    throw new ConfigException(L.l("Timeout trying to obtain unique lock to {0}. Check for other active Resin processes.", (Object)lockPath.getNativePath()));
                }
            }
            catch (IOException e) {
                throw new ConfigException(L.l("Can't obtain unique lock to {0}. Check for other active Resin processes.", (Object)lockPath.getNativePath()));
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        try {
            if (this._fileLock != null) {
                try {
                    Method closeMethod = this._fileLock.getClass().getMethod("close", new Class[0]);
                    if (closeMethod != null) {
                        closeMethod.invoke((Object)this._fileLock, new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
            if (this._foutLock != null) {
                this._foutLock.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

