/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp.server;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.actor.BamSkeleton;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.HashMapBroker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.PassthroughMailbox;
import com.caucho.bam.stream.FallbackMessageStream;
import com.caucho.bam.stream.MessageStream;
import com.caucho.hmtp.server.ClientLinkActor;
import com.caucho.hmtp.server.HmtpClientWebSocketListener;
import com.caucho.websocket.WebSocketListener;
import com.caucho.websocket.WebSocketServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class HmtpServlet
extends HttpServlet
implements ActorHolder,
Actor {
    private static final Logger log = Logger.getLogger(HmtpServlet.class.getName());
    private final AtomicInteger _gId = new AtomicInteger();
    private String _address;
    private ManagedBroker _servletBroker;
    private Actor _servletActorStream = this;
    private BamSkeleton _skeleton;
    private MessageStream _servletFallbackStream;
    private ActorHolder _actor;
    private HashMapBroker _broker;
    private Mailbox _mailbox;

    public HmtpServlet() {
        this._address = this.getClass().getSimpleName() + "@localhost";
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public void setAddress(String address) {
        this._address = address;
    }

    public String getBrokerAddress() {
        return this.getClass().getSimpleName() + ".broker.localhost";
    }

    public void init() {
        this._broker = new HashMapBroker(this.getBrokerAddress());
        this._skeleton = BamSkeleton.getSkeleton(this.getClass());
        Mailbox servletMailbox = this.createServletMailbox();
        String address = servletMailbox.getAddress();
        this._broker.addMailbox(address, servletMailbox);
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        WebSocketServletRequest req = (WebSocketServletRequest)request;
        WebSocketListener listener = this.createWebSocketListener();
        req.startWebSocket(listener);
    }

    protected WebSocketListener createWebSocketListener() {
        return new HmtpClientWebSocketListener(this);
    }

    protected ClientLinkActor createClientLinkActor(String uid, MessageStream hmtpStream) {
        if (uid == null) {
            uid = "anon";
        }
        int resource = this._gId.incrementAndGet();
        String address = uid + "@" + this.getBrokerAddress() + "/" + resource;
        return new ClientLinkActor(address, this._broker, hmtpStream);
    }

    public void addClientLinkActor(ClientLinkActor linkActor) {
        this._broker.createAgent(linkActor.getActorStream());
    }

    public void removeClientLinkActor(ActorHolder linkActor) {
    }

    public void destroyClientLinkActor(ActorHolder linkActor) {
    }

    protected Mailbox createServletMailbox() {
        this._servletFallbackStream = new FallbackMessageStream(this);
        return new PassthroughMailbox(this.getAddress(), this, this._broker);
    }

    @Override
    public Actor getActor() {
        return this._servletActorStream;
    }

    public void setActorStream(Actor actorStream) {
        this._servletActorStream = actorStream;
    }

    @Override
    public ManagedBroker getBroker() {
        return this._broker;
    }

    @Override
    public void setBroker(Broker broker) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Mailbox getMailbox() {
        return this._mailbox;
    }

    @Override
    public void setMailbox(Mailbox mailbox) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected MessageStream getFallbackStream() {
        return this._servletFallbackStream;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        this._skeleton.message(this, this._servletFallbackStream, to, from, payload);
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        this._skeleton.messageError(this, this.getFallbackStream(), to, from, payload, error);
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        this._skeleton.query(this, this.getFallbackStream(), this.getBroker(), id, to, from, payload);
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        this._skeleton.queryResult(this, this.getFallbackStream(), id, to, from, payload);
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        this._skeleton.queryError(this, this.getFallbackStream(), id, to, from, payload, error);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

