/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.ConnectionImpl;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.connection.TopicPublisherImpl;
import com.caucho.jms.queue.AbstractTopic;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;

public class TopicSessionImpl
extends JmsSession
implements XATopicSession,
TopicSession {
    public TopicSessionImpl(ConnectionImpl conn, boolean isTransacted, int ackMode, boolean isXA) throws JMSException {
        super(conn, isTransacted, ackMode, isXA);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkOpen();
        return new TopicPublisherImpl((JmsSession)this, (AbstractTopic)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkOpen();
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException(L.l("TopicSession: createBrowser() is invalid."));
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException(L.l("TopicSession: createBrowser() is invalid."));
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException(L.l("TopicSession: createQueue() is invalid."));
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException(L.l("TopicSession: createTemporaryQueue() is invalid."));
    }

    public TopicSession getTopicSession() {
        return this;
    }
}

