/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.file.FileTopicImpl;
import com.caucho.jms.memory.MemoryQueueImpl;
import com.caucho.jms.queue.MessageTopicSubscriber;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSubscriberQueue<E>
extends MemoryQueueImpl<E>
implements MessageTopicSubscriber<E> {
    private static final Logger log = Logger.getLogger(FileSubscriberQueue.class.getName());
    private FileTopicImpl<E> _topic;
    private Object _publisher;
    private boolean _isNoLocal;

    FileSubscriberQueue(FileTopicImpl<E> topic, String publisher, boolean noLocal) {
        this._topic = topic;
        this._publisher = publisher;
        this._isNoLocal = noLocal;
        if (noLocal && publisher == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void send(String msgId, E msg, int priority, long timeout, String publisherId) {
        if (this._isNoLocal && this._publisher.equals(publisherId)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " send message " + msg);
        }
        super.send(msgId, msg, priority, timeout, publisherId);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._topic.getName() + "]";
    }
}

