/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedSessionImpl
implements ManagedConnection {
    private static final Logger log = Logger.getLogger(ManagedSessionImpl.class.getName());
    private static final L10N L = new L10N(ManagedSessionImpl.class);
    private ConnectionEventListener _listener;
    private ConnectionEvent _connClosedEvent;
    private Destination _destination;
    private Connection _connection;
    private Session _session;
    private MessageProducer _producer;

    public ManagedSessionImpl(ConnectionFactory factory, Destination destination) throws ResourceException {
        this._destination = destination;
        try {
            this._connection = factory.createConnection();
            this._session = this._connection.createSession(false, 1);
            this._producer = this._session.createProducer(destination);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public ManagedConnectionMetaData getMetaData() {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException();
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._listener = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listener = null;
    }

    public ConnectionEventListener getConnectionEventListener() {
        return this._listener;
    }

    public Object getConnection(Subject subj, ConnectionRequestInfo info) {
        return this;
    }

    public void associateConnection(Object o) throws ResourceException {
        throw new NotSupportedException();
    }

    Session getSession() {
        return this._session;
    }

    void send(Message message) throws JMSException {
        this._producer.send(message);
    }

    void close() {
        if (this._listener != null) {
            ConnectionEvent evt = new ConnectionEvent((ManagedConnection)this, 1);
            evt.setConnectionHandle((Object)this);
            this._listener.connectionClosed(evt);
        }
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter out) {
    }

    public void cleanup() throws ResourceException {
    }

    public void destroy() throws ResourceException {
        try {
            this._producer.close();
            this._session.close();
            this._connection.close();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

