/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.jms.message.BytesMessageImpl;
import com.caucho.jms.message.MapMessageImpl;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.message.StreamMessageImpl;
import com.caucho.jms.message.TextMessageImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageFactory {
    private static final Logger log = Logger.getLogger(MessageFactory.class.getName());
    private static final MessageType[] MESSAGE_TYPE = MessageType.values();

    public TextMessage createTextMessage() {
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String msg) throws JMSException {
        TextMessageImpl textMessage = new TextMessageImpl();
        textMessage.setText(msg);
        return textMessage;
    }

    public MessageType getMessageType(Message msg) {
        if (msg instanceof TextMessage) {
            return MessageType.TEXT;
        }
        if (msg instanceof BytesMessage) {
            return MessageType.BYTES;
        }
        if (msg instanceof MapMessage) {
            return MessageType.MAP;
        }
        if (msg instanceof ObjectMessage) {
            return MessageType.OBJECT;
        }
        if (msg instanceof StreamMessage) {
            return MessageType.STREAM;
        }
        return MessageType.NULL;
    }

    public MessageImpl createMessage(int type) {
        if (type < 0 && MESSAGE_TYPE.length <= type) {
            return null;
        }
        switch (MESSAGE_TYPE[type]) {
            case NULL: {
                return new MessageImpl();
            }
            case BYTES: {
                return new BytesMessageImpl();
            }
            case MAP: {
                return new MapMessageImpl();
            }
            case OBJECT: {
                return new ObjectMessageImpl();
            }
            case STREAM: {
                return new StreamMessageImpl();
            }
            case TEXT: {
                return new TextMessageImpl();
            }
        }
        return new MessageImpl();
    }

    public MessageImpl copy(Message msg) throws JMSException {
        if (msg instanceof MessageImpl) {
            return ((MessageImpl)msg).copy();
        }
        if (msg instanceof TextMessage) {
            return new TextMessageImpl((TextMessage)msg);
        }
        if (msg instanceof MapMessage) {
            return new MapMessageImpl((MapMessage)msg);
        }
        if (msg instanceof BytesMessage) {
            return new BytesMessageImpl((BytesMessage)msg);
        }
        if (msg instanceof StreamMessage) {
            return new StreamMessageImpl((StreamMessage)msg);
        }
        if (msg instanceof ObjectMessage) {
            return new ObjectMessageImpl((ObjectMessage)msg);
        }
        if (msg != null) {
            return new MessageImpl(msg);
        }
        throw new NullPointerException();
    }

    public InputStream headerToInputStream(Message msg) {
        try {
            TempStream ts = new TempStream();
            ts.openWrite();
            WriteStream out = new WriteStream(ts);
            this.writeHeader(out, msg);
            out.close();
            return ts.openRead();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHeader(WriteStream out, Message msg) {
    }
}

