/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jslib;

import com.caucho.util.Exit;
import com.caucho.util.ExitListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class Database {
    private DataSource dataSource;
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private static ExitListener exitHandler = new ExitListener(){

        @Override
        public void handleExit(Object o) {
            Database db = (Database)o;
            try {
                db.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    };

    public Database(String name) throws Exception {
        InitialContext cxt = null;
        try {
            cxt = new InitialContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (cxt != null) {
                this.dataSource = (DataSource)cxt.lookup(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dataSource == null && cxt != null) {
                this.dataSource = (DataSource)cxt.lookup("java:comp/env/" + name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dataSource != null && cxt != null) {
                this.dataSource = (DataSource)cxt.lookup("java:comp/env/jdbc/" + name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataSource == null) {
            throw new SQLException("no data source: " + name);
        }
        Exit.addExit(exitHandler, this);
    }

    public ResultSet query(String sql) throws SQLException {
        if (this.rs != null) {
            ResultSet rs = this.rs;
            this.rs = null;
            rs.close();
        }
        Statement stmt = this.getStatement();
        this.rs = stmt.executeQuery(sql);
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) throws SQLException {
        if (this.rs != null) {
            ResultSet rs = this.rs;
            this.rs = null;
            rs.close();
        }
        Connection conn = this.dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            int count = stmt.executeUpdate(sql);
            stmt.close();
            int n = count;
            return n;
        }
        finally {
            conn.close();
        }
    }

    public DataSource getDataSource() throws SQLException {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.conn = this.dataSource.getConnection();
        }
        return this.conn;
    }

    public void commit() throws SQLException {
        if (this.conn != null) {
            Connection conn = this.conn;
            this.conn = null;
            this.stmt = null;
            this.rs = null;
            conn.close();
        }
    }

    public Statement getStatement() throws SQLException {
        if (this.stmt == null) {
            Connection conn = this.getConnection();
            this.stmt = conn.createStatement();
        }
        return this.stmt;
    }

    public PreparedStatement prepare(String sql) throws SQLException {
        Connection conn = this.getConnection();
        return conn.prepareStatement(sql);
    }

    public void close() throws SQLException {
        try {
            if (this.rs != null) {
                ResultSet rs = this.rs;
                this.rs = null;
                rs.close();
            }
            if (this.stmt != null) {
                Statement stmt = this.stmt;
                this.stmt = null;
                stmt.close();
            }
        }
        finally {
            this.stmt = null;
            this.rs = null;
            if (this.conn != null) {
                Connection conn = this.conn;
                this.conn = null;
                conn.close();
            }
        }
    }
}

