/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsmp;

import com.caucho.bam.BamError;
import com.caucho.bam.ProtocolException;
import com.caucho.bam.actor.AbstractActor;
import com.caucho.jsmp.JsmpWriter;
import com.caucho.remote.websocket.WebSocketContextStreamImpl;
import com.caucho.util.IoUtil;
import com.caucho.vfs.WriteStream;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public class JsmpWebSocketWriter
extends AbstractActor {
    private String _address;
    private WebSocketContext _wsContext;
    private JsmpWriter _jsOut;

    public JsmpWebSocketWriter(WriteStream out) throws IOException {
        this(new WebSocketContextStreamImpl(out));
    }

    public JsmpWebSocketWriter(WebSocketContext context) throws IOException {
        this._wsContext = context;
        this._jsOut = new JsmpWriter();
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        PrintWriter out = null;
        try {
            out = this._wsContext.startTextMessage();
            this._jsOut.message(out, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        PrintWriter out = null;
        try {
            out = this._wsContext.startTextMessage();
            this._jsOut.messageError(out, to, from, payload, error);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        PrintWriter out = null;
        try {
            out = this._wsContext.startTextMessage();
            this._jsOut.query(out, id, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        PrintWriter out = null;
        try {
            out = this._wsContext.startTextMessage();
            this._jsOut.queryResult(out, id, to, from, payload);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        PrintWriter out = null;
        try {
            out = this._wsContext.startTextMessage();
            this._jsOut.queryError(out, id, to, from, payload, error);
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
        finally {
            IoUtil.close(out);
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public void flush() {
    }

    public void close() {
    }
}

