/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.AbstractBodyContent;
import com.caucho.jsp.AbstractJspWriter;
import com.caucho.jsp.PageContextImpl;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class JspWriterAdapter
extends AbstractBodyContent {
    private static final Logger log = Logger.getLogger(JspWriterAdapter.class.getName());
    private AbstractResponseStream _out;
    private HttpServletResponse _response;
    private boolean _isClosed;

    JspWriterAdapter() {
    }

    void init(PageContextImpl pageContext) {
        this._out = null;
        this._isClosed = false;
    }

    void init(JspWriter parent, HttpServletResponse response, AbstractResponseStream out) {
        this._out = out;
        if (response instanceof CauchoResponse) {
            this._response = (CauchoResponse)response;
        }
        this._isClosed = false;
    }

    @Override
    public final void write(char[] buf, int offset, int length) throws IOException {
        if (this._isClosed) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(buf[offset + i])) continue;
                this.closeError("write()");
            }
        }
        this._out.print(buf, offset, length);
    }

    @Override
    public final void write(int ch) throws IOException {
        if (this._isClosed) {
            if (Character.isWhitespace(ch)) {
                return;
            }
            this.closeError("write()");
        }
        this._out.print(ch);
    }

    @Override
    public final void println() throws IOException {
        if (this._isClosed) {
            this.closeError("println()");
        }
        this._out.print(10);
    }

    @Override
    public final void write(String s, int off, int len) throws IOException {
        if (this._isClosed) {
            int i = 0;
            while (i < len) {
                if (!Character.isWhitespace(s.charAt(off + i))) {
                    this.closeError("write()");
                }
                ++len;
            }
        }
        char[] writeBuffer = this._out.getCharBuffer();
        int size = writeBuffer.length;
        int writeLength = this._out.getCharOffset();
        int end = off + len;
        while (off < end) {
            int sublen = Math.min(size - writeLength, end - off);
            if (sublen == 0) {
                writeBuffer = this._out.nextCharBuffer(writeLength);
                writeLength = this._out.getCharOffset();
                sublen = Math.min(size - writeLength, end - off);
            }
            int tail = off + sublen;
            s.getChars(off, tail, writeBuffer, writeLength);
            off = tail;
            writeLength += sublen;
        }
        this._out.setCharOffset(writeLength);
    }

    @Override
    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    @Override
    public int getRemaining() {
        return this._out.getRemaining();
    }

    @Override
    public void clear() throws IOException {
        if (this._isClosed) {
            this.closeError("clear()");
        }
        this._out.clear();
    }

    @Override
    public void clearBuffer() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.clearBuffer();
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this._isClosed) {
            this.closeError("flushBuffer()");
        }
        this._out.flushBuffer();
    }

    @Override
    public void flush() throws IOException {
        if (this._isClosed) {
            this.closeError("flush()");
        }
        if (this._response != null) {
            this._response.flushBuffer();
            this._out.flush();
        } else {
            this._out.flush();
        }
    }

    private void closeError(String op) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " " + op + " forbidden after writer is closed");
        }
        throw new IOException(this + " " + op + " forbidden after writer is closed");
    }

    @Override
    AbstractJspWriter popWriter() {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return super.popWriter();
    }

    @Override
    public final void close() throws IOException {
        this._isClosed = true;
        AbstractResponseStream out = this._out;
        this._out = null;
        if (out != null && !out.isCauchoResponseStream()) {
            out.flushBuffer();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

