/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Xsl;
import java.lang.ref.SoftReference;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.Templates;

class XslManager {
    private static final Logger log = Logger.getLogger(XslManager.class.getName());
    static final L10N L = new L10N(XslManager.class);
    private WebApp _webApp;
    private Path _workPath;
    private LruCache<String, SoftReference<Templates>> _xslCache = new LruCache(256);
    private boolean _strictXsl;
    private long _lastUpdate;

    public XslManager(ServletContext context) {
        this._webApp = (WebApp)context;
        this._workPath = CauchoSystem.getWorkPath();
    }

    public void setStrictXsl(boolean strictXsl) {
        this._strictXsl = strictXsl;
    }

    public String getServletInfo() {
        return "Resin XTP";
    }

    Templates get(String href, CauchoRequest req) throws Exception {
        String servletPath = req.getPageServletPath();
        WebApp webApp = req.getWebApp();
        Path appDir = webApp.getRootDirectory();
        Path pwd = appDir.lookupNative(webApp.getRealPath(servletPath));
        pwd = pwd.getParent();
        String fullStyleSheet = pwd.toString() + "/" + href;
        Templates stylesheet = null;
        long now = CurrentTime.getCurrentTime();
        SoftReference<Templates> templateRef = this._xslCache.get(fullStyleSheet);
        if (templateRef != null) {
            stylesheet = templateRef.get();
        }
        if (stylesheet instanceof StylesheetImpl && !((StylesheetImpl)stylesheet).isModified()) {
            return stylesheet;
        }
        this._lastUpdate = now;
        stylesheet = this.getStylesheet(req, href);
        if (stylesheet == null) {
            throw new ServletException(L.l("can't find stylesheet `{0}'", (Object)href));
        }
        this._xslCache.put(fullStyleSheet, new SoftReference<Templates>(stylesheet));
        return stylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Templates getStylesheet(CauchoRequest req, String href) throws Exception {
        DynamicClassLoader owningLoader;
        String servletPath = req.getPageServletPath();
        WebApp webApp = req.getWebApp();
        Path appDir = webApp.getRootDirectory();
        Path pwd = appDir.lookupNative(webApp.getRealPath(servletPath));
        pwd = pwd.getParent();
        DynamicClassLoader loader = (DynamicClassLoader)webApp.getClassLoader();
        MergePath stylePath = new MergePath();
        stylePath.addMergePath(pwd);
        stylePath.addMergePath(appDir);
        String resourcePath = loader.getResourcePathSpecificFirst();
        stylePath.addClassPath(resourcePath);
        Path hrefPath = stylePath.lookup(href);
        if (hrefPath.canRead() && (owningLoader = this.getStylesheetLoader(href, hrefPath)) != null) {
            loader = owningLoader;
            stylePath = new MergePath();
            stylePath.addMergePath(pwd);
            stylePath.addMergePath(appDir);
            resourcePath = loader.getResourcePathSpecificFirst();
            stylePath.addClassPath(resourcePath);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            int p;
            thread.setContextClassLoader(loader);
            AbstractStylesheetFactory factory = this._strictXsl ? new Xsl() : new StyleScript();
            factory.setStylePath(stylePath);
            factory.setClassLoader(loader);
            String className = "";
            if (pwd.lookup(href).canRead() && (p = req.getServletPath().lastIndexOf(47)) >= 0) {
                className = className + req.getServletPath().substring(0, p);
            }
            className = className + "/" + href;
            factory.setClassName(className);
            Templates templates = factory.newTemplates(href);
            return templates;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private DynamicClassLoader getStylesheetLoader(String href, Path sourcePath) {
        DynamicClassLoader owningLoader = null;
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
            MergePath mp = new MergePath();
            String resourcePath = dynLoader.getResourcePathSpecificFirst();
            mp.addClassPath(resourcePath);
            Path loaderPath = mp.lookup(href);
            if (!loaderPath.getNativePath().equals(sourcePath.getNativePath())) continue;
            owningLoader = dynLoader;
        }
        return owningLoader;
    }
}

