/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.TagInstance;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspContainerNode;
import com.caucho.jsp.java.JspExpression;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.JspSegmentNode;
import com.caucho.jsp.java.StaticText;
import com.caucho.util.CharBuffer;

public abstract class JspFragmentNode
extends JspContainerNode
implements JspSegmentNode {
    private int _fragmentCode;
    private String _fragmentName;
    private boolean _isValueFragment;
    private boolean _isJspFragment;

    @Override
    public void endAttributes() throws JspParseException {
        this._fragmentCode = this._gen.uniqueId();
        this._fragmentName = "_jsp_fragment_" + this._fragmentCode;
    }

    public String getFragmentName() {
        return this._fragmentName;
    }

    @Override
    public String getCustomTagName() {
        return "_jsp_parent_tag";
    }

    @Override
    public JspNode addText(String text) throws JspParseException {
        StaticText node = new StaticText(this._gen, text, this);
        this.addChild(node);
        return node;
    }

    public boolean isTrim() {
        return false;
    }

    @Override
    public boolean isStatic() {
        if (this._children == null) {
            return true;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            if (((JspNode)this._children.get(i)).isStatic()) continue;
            return false;
        }
        return true;
    }

    public boolean isValueFragment() {
        return this._isValueFragment;
    }

    public int getFragmentCode() {
        return this._fragmentCode;
    }

    public void setJspFragment(boolean isFragment) {
        this._isJspFragment = isFragment;
    }

    public boolean isJspFragment() {
        return this._isJspFragment;
    }

    public void generateFragmentPrologue(JspJavaWriter out) throws Exception {
        if (this._isValueFragment) {
            return;
        }
        this._isJspFragment = true;
        if (this.isStatic()) {
            out.println("com.caucho.jsp.StaticJspFragmentSupport " + this._fragmentName + " = null;");
        } else {
            out.println("_CauchoFragment_" + this._fragmentCode + " " + this._fragmentName + " = null;");
        }
    }

    @Override
    public void generate(JspJavaWriter out) throws Exception {
        if (this.hasScriptingElement() && this.isJspFragment()) {
            JspNode node = this.findScriptingNode();
            if (node == null) {
                throw this.error(L.l("Fragments may not contain scripting elements"));
            }
            if (node._filename.equals(this._filename)) {
                throw node.error(L.l("Fragments may not contain scripting elements"));
            }
        }
        this.generateChildren(out);
    }

    protected String generateValue() throws Exception {
        TagInstance parent;
        JspNode node;
        if (this.isStatic()) {
            return '\"' + JspFragmentNode.escapeJavaString(this.getStaticText()) + '\"';
        }
        this._isValueFragment = true;
        if (this.hasScriptingElement() && this.isJspFragment()) {
            node = this.findScriptingNode();
            if (node == null) {
                throw this.error(L.l("Fragments may not contain scripting elements"));
            }
            if (node._filename.equals(this._filename)) {
                throw node.error(L.l("Fragments may not contain scripting elements"));
            }
        }
        if (this.isSingleExpression()) {
            node = this.findScriptingNode();
            return ((JspExpression)node).generateValue();
        }
        this._gen.addFragment(this);
        CharBuffer cb = new CharBuffer();
        cb.append(this._fragmentName + "(pageContext, ");
        for (parent = this.getParent().getTag(); parent != null && parent.isTagFileTag(); parent = parent.getParent()) {
        }
        if (parent == null || parent.getId() == TagInstance.TOP_TAG) {
            cb.append("null");
        } else if (parent.getId().startsWith("top_")) {
            cb.append("_jsp_parent_tag");
        } else if (!this.hasCustomTag()) {
            cb.append(parent.getId());
        } else if (parent.isSimpleTag()) {
            cb.append(parent.getId() + "_adapter");
        } else {
            cb.append(parent.getId());
        }
        if (this._gen instanceof JavaTagGenerator) {
            JavaTagGenerator tagGen = (JavaTagGenerator)this._gen;
            if (tagGen.isStaticDoTag()) {
                cb.append(", _jspBody");
            } else {
                cb.append(", getJspBody()");
            }
        } else {
            cb.append(", null");
        }
        cb.append(", _jsp_state");
        cb.append(", _jsp_pageManager");
        cb.append(")");
        return cb.close();
    }

    void generateValueMethod(JspJavaWriter out) throws Exception {
        if (this.hasScriptingElement() && this.isJspFragment()) {
            JspNode node = this.findScriptingNode();
            if (node == null) {
                throw this.error(L.l("Fragments may not contain scripting elements"));
            }
            if (node._filename.equals(this._filename)) {
                throw node.error(L.l("Fragments may not contain scripting elements"));
            }
        }
        out.println();
        out.println("String " + this._fragmentName + "(");
        out.println("  com.caucho.jsp.PageContextImpl pageContext,");
        out.println("  javax.servlet.jsp.tagext.JspTag _jsp_parent_tag,");
        out.println("  javax.servlet.jsp.tagext.JspFragment _jspBody,");
        out.println("  TagState _jsp_state,");
        out.println("  com.caucho.jsp.PageManager _jsp_pageManager)");
        out.println("  throws Throwable");
        out.println("{");
        out.pushDepth();
        out.println("com.caucho.jsp.PageContextImpl _jsp_parentContext = pageContext;");
        out.println("JspWriter out = pageContext.pushBody();");
        out.println("javax.el.ELContext _jsp_env = pageContext.getELContext();");
        if (this.hasScripting()) {
            out.println("javax.servlet.http.HttpServletRequest request = (javax.servlet.http.HttpServletRequest) pageContext.getRequest();");
            out.println("javax.servlet.http.HttpServletResponse response = (javax.servlet.http.HttpServletResponse) pageContext.getResponse();");
            out.println("javax.servlet.http.HttpSession session = pageContext.getSession();");
            out.println("javax.servlet.ServletContext application = pageContext.getServletContext();");
            out.println("javax.servlet.ServletConfig config = pageContext.getServletConfig();");
        }
        out.println("try {");
        out.pushDepth();
        this.generatePrologue(out);
        this.generate(out);
        out.print("return ((com.caucho.jsp.BodyContentImpl) out)");
        out.println(".getString();");
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        out.println("pageContext.popAndReleaseBody();");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }
}

