/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.JarMap;
import com.caucho.loader.Loader;
import com.caucho.make.DependencyContainer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Jar;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public abstract class JarListLoader
extends Loader
implements Dependency {
    private static final Logger log = Logger.getLogger(JarListLoader.class.getName());
    protected ArrayList<JarEntry> _jarList = new ArrayList();
    private DependencyContainer _dependencyList = new DependencyContainer();
    private JarMap _pathMap;

    public JarListLoader() {
    }

    public JarListLoader(ClassLoader loader) {
        super(loader);
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
    }

    @Override
    public boolean isModified() {
        return this._dependencyList.isModified();
    }

    @Override
    public boolean logModified(Logger log) {
        return this._dependencyList.logModified(log);
    }

    @Override
    public void validate() throws ConfigException {
        for (int i = 0; i < this._jarList.size(); ++i) {
            this._jarList.get(i).validate();
        }
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this._jarList.size(); ++i) {
            this.getClassLoader().addURL(this._jarList.get(i).getJarPath());
        }
    }

    protected boolean isJarCacheEnabled() {
        DynamicClassLoader loader = this.getClassLoader();
        if (loader != null) {
            return loader.isJarCacheEnabled();
        }
        return false;
    }

    protected void addJar(Path jar) {
        if (!jar.exists()) {
            log.fine(jar.getTail() + " does not exist (path=" + jar.getNativePath() + ")");
            return;
        }
        if (!jar.canRead()) {
            log.warning(jar.getTail() + " is unreadable (uid=" + jar.getUser() + " mode=" + String.format("%o", jar.getMode()) + " path=" + jar.getNativePath() + ")");
            return;
        }
        JarPath jarPath = JarPath.create(jar);
        try {
            jarPath.getCertificates();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        JarEntry jarEntry = new JarEntry(jarPath);
        if (this.getClassLoader() != null && !this.getClassLoader().addURL(jarPath)) {
            return;
        }
        if (this._jarList.contains(jarEntry)) {
            return;
        }
        this._jarList.add(jarEntry);
        this._dependencyList.add(new Depend(jar));
        if (this._pathMap == null && this.isJarCacheEnabled()) {
            this._pathMap = new JarMap();
        }
        if (this._pathMap != null) {
            this._pathMap.scan(jar, jarEntry);
        }
    }

    @Override
    protected void buildClassPath(ArrayList<String> pathList) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            String path = jar.getContainer().getNativePath();
            if (pathList.contains(path)) continue;
            pathList.add(path);
        }
    }

    @Override
    protected ClassEntry getClassEntry(String name, String pathName) throws ClassNotFoundException {
        if (this._pathMap != null) {
            JarMap.JarList jarEntryList = this._pathMap.get(pathName);
            if (jarEntryList != null) {
                JarEntry jarEntry = jarEntryList.getEntry();
                JarPath path = jarEntry.getJarPath();
                Path filePath = path.lookup(pathName);
                return this.createEntry(name, pathName, jarEntry, filePath);
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                JarPath path = jarEntry.getJarPath();
                Jar jar = path.getJar();
                try {
                    ZipEntry zipEntry = jar.getZipEntry(pathName);
                    if (zipEntry == null || zipEntry.getSize() <= 0L) continue;
                    Path filePath = path.lookup(pathName);
                    return this.createEntry(name, pathName, jarEntry, filePath);
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        return null;
    }

    private ClassEntry createEntry(String name, String pathName, JarEntry jarEntry, Path filePath) {
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        ClassEntry entry = new ClassEntry(this.getClassLoader(), name, filePath, filePath, jarEntry.getCodeSource(pathName));
        ClassPackage classPackage = jarEntry.getPackage(pkg);
        entry.setClassPackage(classPackage);
        return entry;
    }

    @Override
    public void getResources(Vector<URL> vector, String name) {
        if (this._pathMap != null) {
            String cleanName = name;
            if (cleanName.endsWith("/")) {
                cleanName = cleanName.substring(0, cleanName.length() - 1);
            }
            for (JarMap.JarList jarEntryList = this._pathMap.get(cleanName); jarEntryList != null; jarEntryList = jarEntryList.getNext()) {
                JarEntry jarEntry = jarEntryList.getEntry();
                Path path = jarEntry.getJarPath();
                path = path.lookup(name);
                try {
                    URL url = new URL(path.getURL());
                    if (vector.contains(url)) continue;
                    vector.add(url);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                Path path = jarEntry.getJarPath();
                if (!(path = path.lookup(name)).exists()) continue;
                try {
                    URL url = new URL(path.getURL());
                    if (vector.contains(url)) continue;
                    vector.add(url);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    @Override
    public Path getPath(String pathName) {
        if (this._pathMap != null) {
            JarMap.JarList jarEntryList;
            String cleanPathName = pathName;
            if (cleanPathName.endsWith("/")) {
                cleanPathName = cleanPathName.substring(0, cleanPathName.length() - 1);
            }
            if ((jarEntryList = this._pathMap.get(cleanPathName)) != null) {
                return jarEntryList.getEntry().getJarPath().lookup(pathName);
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                JarPath path = jarEntry.getJarPath();
                Path filePath = path.lookup(pathName);
                if (!filePath.exists()) continue;
                return filePath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearJars() {
        JarListLoader jarListLoader = this;
        synchronized (jarListLoader) {
            ArrayList<JarEntry> jars = new ArrayList<JarEntry>(this._jarList);
            this._jarList.clear();
            if (this._pathMap != null) {
                this._pathMap.clear();
            }
            for (int i = 0; i < jars.size(); ++i) {
                JarEntry jarEntry = jars.get(i);
                JarPath jarPath = jarEntry.getJarPath();
                jarPath.closeJar();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jarList + "]";
    }
}

