/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.encode;

import com.caucho.message.MessageDecoder;
import com.caucho.message.encode.AbstractNautilusDecoder;
import com.caucho.message.encode.NautilusCodes;
import com.caucho.message.encode.NullDecoder;
import com.caucho.message.encode.StringDecoder;
import com.caucho.message.encode.UnsupportedDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class NautilusDecoder
extends AbstractNautilusDecoder<Object> {
    public static final NautilusDecoder DECODER = new NautilusDecoder();
    private final MessageDecoder<?>[] _decoderArray = new MessageDecoder[256];

    public NautilusDecoder() {
        for (int i = 0; i < this._decoderArray.length; ++i) {
            this._decoderArray[i] = new UnsupportedDecoder("code = 0x" + Integer.toHexString(i));
        }
        this._decoderArray[NautilusCodes.NULL.getValue()] = NullDecoder.DECODER;
        this._decoderArray[NautilusCodes.STRING.getValue()] = StringDecoder.DECODER;
    }

    @Override
    public Object decode(InputStream is) throws IOException {
        int code = is.read();
        if (code < 0) {
            throw new EOFException();
        }
        return this._decoderArray[code].decode(is);
    }
}

