/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.stomp;

import com.caucho.env.thread.ThreadPool;
import com.caucho.message.stomp.StompClientReceiver;
import com.caucho.message.stomp.StompClientSubscriber;
import com.caucho.util.IoUtil;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StompClient {
    private static final Logger log = Logger.getLogger(StompClient.class.getName());
    private String _address;
    private int _port;
    private ReadStream _is;
    private WriteStream _os;
    private Socket _s;
    private StompClientReceiver _receiver;
    private ConcurrentHashMap<String, StompClientSubscriber> _subscriptions = new ConcurrentHashMap();
    private int _subId;

    public StompClient(String address, int port) {
        this._address = address;
        this._port = port;
    }

    public void connect(String user, String password) throws IOException {
        this._s = new Socket(this._address, this._port);
        this._is = Vfs.openRead(this._s.getInputStream());
        this._os = Vfs.openWrite(this._s.getOutputStream());
        this._os.print("CONNECT\n");
        this._os.print("user:" + user + "\n");
        this._os.print("password:" + password + "\n");
        this._os.print("\n\u0000");
        this._os.flush();
        this._receiver = new StompClientReceiver(this, this._is);
        if (!this._receiver.readMessage()) {
            this.close();
            throw new IOException("can't connect");
        }
        if (!this._receiver.isConnected()) {
            this.close();
            throw new IOException("can't connect2");
        }
        ThreadPool.getCurrent().schedule(this._receiver);
    }

    public void send(String dest, String msg) throws IOException {
        this._os.print("SEND\n");
        this._os.print("destination:" + dest + "\n");
        this._os.print("content-length:" + msg.length() + "\n");
        this._os.print("\n");
        this._os.print(msg);
        this._os.print("\u0000");
        this._os.flush();
    }

    public StompClientSubscriber createSubscription(String dest) throws IOException {
        String sid = "t" + this._subId++;
        StompClientSubscriber sub = new StompClientSubscriber(this, sid);
        this._subscriptions.put(sid, sub);
        this._os.print("SUBSCRIBE\n");
        this._os.print("destination:" + dest + "\n");
        this._os.print("id:" + sid + "\n");
        this._os.print("\n");
        this._os.print("\u0000");
        this._os.flush();
        return sub;
    }

    void addMessage(String subId, HashMap<String, String> headers, String body) {
        StompClientSubscriber sub = this._subscriptions.get(subId);
        if (sub != null) {
            sub.addMessage(headers, body);
        } else {
            System.out.println("UNKNOWN_SUB: " + subId);
        }
    }

    public void close() {
        try {
            this.disconnect();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            this.closeSockets();
        }
    }

    private void disconnect() throws IOException {
        WriteStream out = this._os;
        if (out == null) {
            return;
        }
        out.println("DISCONNECT\n\n\u0000");
        out.flush();
    }

    private void closeSockets() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        Socket s = this._s;
        this._s = null;
        StompClientReceiver receiver = this._receiver;
        this._receiver = null;
        if (receiver != null) {
            receiver.close();
        }
        for (StompClientSubscriber sub : this._subscriptions.values()) {
            sub.close();
        }
        this._subscriptions.clear();
        IoUtil.close(is);
        IoUtil.close(os);
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

