/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote;

import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.broker.PassthroughBroker;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.config.Admin;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.servlet.ClientStubManager;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.hemp.servlet.ServerLinkActor;
import com.caucho.hemp.servlet.ServerProxyBroker;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWebSocketContextWriter;
import com.caucho.security.Authenticator;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.util.L10N;
import com.caucho.websocket.AbstractWebSocketListener;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HmtpServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(HmtpServlet.class.getName());
    private static final L10N L = new L10N(HmtpServlet.class);
    private boolean _isAdmin;
    private boolean _isAuthenticationRequired = true;
    @Inject
    private Instance<Authenticator> _authInstance;
    @Inject
    @Admin
    private Instance<Authenticator> _adminInstance;
    private ManagedBroker _broker;
    private Authenticator _auth;
    private ServerAuthManager _authManager;

    public void setAdmin(boolean isAdmin) {
        this._isAdmin = isAdmin;
    }

    public void setAuthenticationRequired(boolean isAuthRequired) {
        this._isAuthenticationRequired = isAuthRequired;
    }

    public boolean isAuthenticationRequired() {
        return this._isAuthenticationRequired;
    }

    public void init() {
        block5: {
            String admin;
            String authRequired = this.getInitParameter("authentication-required");
            if ("false".equals(authRequired)) {
                this._isAuthenticationRequired = false;
            }
            if ("true".equals(admin = this.getInitParameter("admin"))) {
                this._isAdmin = true;
            }
            this._authManager = new ServerAuthManager();
            this._authManager.setAuthenticationRequired(this._isAuthenticationRequired);
            try {
                this._auth = this._isAdmin ? (Authenticator)this._adminInstance.get() : (Authenticator)this._authInstance.get();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("{0} requires an active com.caucho.security.Authenticator because HMTP messaging requires authenticated login for security.", (Object)this), e);
                }
                if (this._authManager.isClusterSystemKey() || !this._isAuthenticationRequired) break block5;
                log.info(L.l("{0} requires an active com.caucho.security.Authenticator because HMTP messaging requires authenticated login for security.  In the resin.xml, add an <sec:AdminAuthenticator>", (Object)this));
            }
        }
        this._broker = this._isAdmin ? ServletService.getCurrent().getAdminBroker() : HempBroker.getCurrent();
        log.fine(L.l("{0} starting with broker={1}", (Object)this, (Object)this._broker));
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequestImpl req = (HttpServletRequestImpl)request;
        HttpServletResponseImpl res = (HttpServletResponseImpl)response;
        String upgrade = req.getHeader("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            res.sendError(400, "Upgrade denied:" + upgrade);
            return;
        }
        String ipAddress = req.getRemoteAddr();
        WebSocketHandler handler = new WebSocketHandler(ipAddress);
        WebSocketContext webSocket = req.startWebSocket(handler);
        webSocket.setTimeout(1800000L);
    }

    protected ManagedBroker getBroker() {
        return this._broker;
    }

    class WebSocketHandler
    extends AbstractWebSocketListener {
        private String _ipAddress;
        private HmtpReader _in;
        private HmtpWebSocketContextWriter _out;
        private Broker _linkStream;
        private Broker _broker;
        private ServerLinkActor _linkService;
        private ClientStubManager _clientManager;

        WebSocketHandler(String ipAddress) {
            this._ipAddress = ipAddress;
        }

        @Override
        public void onStart(WebSocketContext context) throws IOException {
            this._in = new HmtpReader();
            this._out = new HmtpWebSocketContextWriter(context);
            ManagedBroker broker = HmtpServlet.this.getBroker();
            MultiworkerMailbox toLinkMailbox = new MultiworkerMailbox(this._out.getAddress(), this._out, broker, 1);
            this._linkStream = new PassthroughBroker(toLinkMailbox);
            this._clientManager = new ClientStubManager(broker, toLinkMailbox);
            this._linkService = new ServerLinkActor(this._linkStream, this._clientManager, HmtpServlet.this._authManager, this._ipAddress);
            this._broker = new ServerProxyBroker(broker, this._clientManager, this._linkService.getActor());
        }

        @Override
        public void onDisconnect(WebSocketContext context) throws IOException {
            ClientStubManager clientManager = this._clientManager;
            this._clientManager = null;
            if (clientManager != null) {
                clientManager.logout();
            }
        }

        @Override
        public void onReadBinary(WebSocketContext context, InputStream is) throws IOException {
            this._in.readPacket(is, this._broker);
        }

        @Override
        public void onTimeout(WebSocketContext context) throws IOException {
        }

        @Override
        public void onReadText(WebSocketContext context, Reader is) throws IOException {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._ipAddress + "]";
        }
    }
}

