/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources;

import com.caucho.config.types.Trigger;

public class TimerTrigger
implements Trigger {
    private long _firstTime;
    private long _period;

    public TimerTrigger() {
    }

    public TimerTrigger(long firstTime) {
        this._firstTime = firstTime;
    }

    public TimerTrigger(long firstTime, long period) {
        this._firstTime = firstTime;
        this._period = period;
    }

    public void setFirstTime(long firstTime) {
        this._firstTime = firstTime;
    }

    public long getFirstTime() {
        return this._firstTime;
    }

    public void setPeriod(long period) {
        this._period = period;
    }

    public long getPeriod() {
        return this._period;
    }

    @Override
    public long nextTime(long now) {
        if (now < this._firstTime) {
            return this._firstTime;
        }
        if (this._period <= 0L) {
            return 0x3FFFFFFFFFFFFFFFL;
        }
        long delta = (now - this._firstTime) % this._period;
        return now + this._period - delta;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._period + "," + this._firstTime + "]";
    }
}

