/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.inject.HandleAware;
import com.caucho.security.AbstractSingleSignon;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.Credentials;
import com.caucho.security.DigestBuilder;
import com.caucho.security.DigestCredentials;
import com.caucho.security.HttpDigestCredentials;
import com.caucho.security.NullSingleSignon;
import com.caucho.security.PasswordCredentials;
import com.caucho.security.PasswordUser;
import com.caucho.security.SingleSignon;
import com.caucho.server.security.PasswordDigest;
import com.caucho.util.Base64;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;

public class AbstractAuthenticator
implements Authenticator,
HandleAware,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractAuthenticator.class.getName());
    private static final SingleSignon NULL_SINGLE_SIGNON = new NullSingleSignon();
    public static final Principal NULL_USER = new BasicPrincipal("null-user");
    protected String _passwordDigestAlgorithm = "MD5-base64";
    protected String _passwordDigestRealm = "resin";
    protected PasswordDigest _passwordDigest;
    private boolean _logoutOnTimeout = true;
    private Object _serializationHandle;
    private SingleSignon _singleSignon;

    public PasswordDigest getPasswordDigest() {
        return this._passwordDigest;
    }

    public void setPasswordDigest(PasswordDigest digest) {
        this._passwordDigest = digest;
    }

    public String getPasswordDigestAlgorithm() {
        return this._passwordDigestAlgorithm;
    }

    public void setPasswordDigestAlgorithm(String digest) {
        this._passwordDigestAlgorithm = digest;
    }

    public String getPasswordDigestRealm() {
        return this._passwordDigestRealm;
    }

    public void setPasswordDigestRealm(String realm) {
        this._passwordDigestRealm = realm;
    }

    public boolean getLogoutOnSessionTimeout() {
        return this._logoutOnTimeout;
    }

    public void setLogoutOnSessionTimeout(boolean logout) {
        this._logoutOnTimeout = logout;
    }

    public void addRoleMapping(Principal principal, String role) {
    }

    @PostConstruct
    public void init() throws ServletException {
        int p;
        if (this._passwordDigest != null) {
            if (this._passwordDigest.getAlgorithm() == null || this._passwordDigest.getAlgorithm().equals("none")) {
                this._passwordDigest = null;
                this._passwordDigestAlgorithm = "none";
            }
        } else if (this._passwordDigestAlgorithm != null && !this._passwordDigestAlgorithm.equals("none") && (p = this._passwordDigestAlgorithm.indexOf(45)) > 0) {
            String algorithm = this._passwordDigestAlgorithm.substring(0, p);
            String format = this._passwordDigestAlgorithm.substring(p + 1);
            this._passwordDigest = new PasswordDigest();
            this._passwordDigest.setAlgorithm(algorithm);
            this._passwordDigest.setFormat(format);
            this._passwordDigest.setRealm(this._passwordDigestRealm);
            this._passwordDigest.init();
        }
    }

    @Override
    public String getAlgorithm(Principal user) {
        String algorithm;
        PasswordUser password = this.getPasswordUser(user);
        if (password != null && (algorithm = this.getAlgorithm(password.getPassword())) != null) {
            return algorithm;
        }
        if (this._passwordDigest != null) {
            return this._passwordDigest.getType();
        }
        return "plain";
    }

    private String getAlgorithm(char[] password) {
        return DigestBuilder.getAlgorithm(password);
    }

    @Override
    public Principal authenticate(Principal user, Credentials credentials, Object details) {
        if (credentials instanceof PasswordCredentials) {
            return this.authenticate(user, (PasswordCredentials)credentials, details);
        }
        if (credentials instanceof HttpDigestCredentials) {
            return this.authenticate(user, (HttpDigestCredentials)credentials, details);
        }
        if (credentials instanceof DigestCredentials) {
            return this.authenticate(user, (DigestCredentials)credentials, details);
        }
        return null;
    }

    @Override
    public boolean isUserInRole(Principal user, String role) {
        PasswordUser passwordUser = this.getPasswordUser(user);
        if (passwordUser != null) {
            return passwordUser.isUserInRole(role);
        }
        return false;
    }

    @Override
    public void logout(Principal user) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout " + user);
        }
    }

    protected Principal authenticate(Principal principal, PasswordCredentials cred, Object details) {
        return this.authenticate(principal, cred.getPassword());
    }

    protected Principal authenticate(Principal principal, char[] password) {
        PasswordUser user = this.getPasswordUser(principal);
        if (user == null || user.isDisabled()) {
            return null;
        }
        String algorithm = "";
        if (!this.isMatch(principal, algorithm, password, user.getPassword()) && !user.isAnonymous()) {
            user = null;
        }
        if (user != null) {
            return user.getPrincipal();
        }
        return null;
    }

    protected Principal authenticate(Principal principal, HttpDigestCredentials cred, Object details) {
        String cnonce = cred.getCnonce();
        String method = cred.getMethod();
        String nc = cred.getNc();
        String nonce = cred.getNonce();
        String qop = cred.getQop();
        String realm = cred.getRealm();
        byte[] clientDigest = cred.getResponse();
        String uri = cred.getUri();
        try {
            int i;
            if (clientDigest == null) {
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] a1 = this.getDigestSecret(principal, realm);
            if (a1 == null) {
                return null;
            }
            this.digestUpdateHex(digest, a1);
            digest.update((byte)58);
            for (i = 0; i < nonce.length(); ++i) {
                digest.update((byte)nonce.charAt(i));
            }
            if (qop != null) {
                digest.update((byte)58);
                for (i = 0; i < nc.length(); ++i) {
                    digest.update((byte)nc.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; cnonce != null && i < cnonce.length(); ++i) {
                    digest.update((byte)cnonce.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; qop != null && i < qop.length(); ++i) {
                    digest.update((byte)qop.charAt(i));
                }
            }
            digest.update((byte)58);
            byte[] a2 = this.digest(method + ":" + uri);
            this.digestUpdateHex(digest, a2);
            byte[] serverDigest = digest.digest();
            if (this.isMatch(clientDigest, serverDigest)) {
                return principal;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Principal authenticate(Principal principal, DigestCredentials cred, Object details) {
        String nonce = cred.getNonce();
        String realm = cred.getRealm();
        String clientDigest = cred.getDigest();
        try {
            int p;
            if (clientDigest == null) {
                return null;
            }
            PasswordUser user = this.getPasswordUser(principal);
            if (user == null || user.isDisabled()) {
                return null;
            }
            String signed = new String(user.getPassword());
            String algorithm = this.getAlgorithm(principal);
            char[] digest = DigestBuilder.getDigest(principal, "", user.getPassword(), user.getPassword());
            if (digest != null) {
                signed = new String(signed);
            } else if (algorithm != null && !"plain".equals(algorithm) && (p = algorithm.lastIndexOf(125)) > 0) {
                signed = algorithm.substring(0, p + 1) + signed;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(principal.getName().getBytes("UTF-8"));
            md.update(nonce.getBytes("UTF-8"));
            md.update(signed.getBytes("UTF-8"));
            byte[] serverDigest = md.digest();
            if (clientDigest.equals(Base64.encode(serverDigest))) {
                return principal;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected char[] getPasswordDigest(String user, char[] password) {
        char[] digest;
        if (this._passwordDigest != null && (digest = this._passwordDigest.getPasswordDigest(user, password)) != null) {
            return digest;
        }
        digest = new char[password.length];
        System.arraycopy(password, 0, digest, 0, password.length);
        return digest;
    }

    protected byte[] getDigestSecret(Principal principal, String realm) {
        PasswordUser user = this.getPasswordUser(principal);
        if (user == null || user.isDisabled()) {
            return null;
        }
        return this.getDigestSecret(principal, realm, user.getPassword());
    }

    protected byte[] getDigestSecret(Principal principal, String realm, char[] userPassword) {
        if (userPassword == null) {
            return null;
        }
        if (this._passwordDigest != null) {
            return this._passwordDigest.stringToDigest(userPassword);
        }
        String username = principal.getName();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String string = username + ":" + realm + ":";
            byte[] data = string.getBytes("UTF8");
            digest.update(data);
            char[] password = userPassword;
            for (int i = 0; i < password.length; ++i) {
                digest.update((byte)password[i]);
            }
            return digest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PasswordUser getPasswordUser(String userName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " getPasswordUser() is not implemented for " + userName);
        }
        return null;
    }

    protected PasswordUser getPasswordUser(Principal principal) {
        return this.getPasswordUser(principal.getName());
    }

    public SingleSignon getSingleSignon() {
        if (this._singleSignon == null) {
            this._singleSignon = AbstractSingleSignon.getCurrent();
            if (this._singleSignon == null) {
                this._singleSignon = NULL_SINGLE_SIGNON;
            }
        }
        if (this._singleSignon != NULL_SINGLE_SIGNON) {
            return this._singleSignon;
        }
        return null;
    }

    private void digestUpdateHex(MessageDigest digest, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int d1 = b >> 4 & 0xF;
            int d2 = b & 0xF;
            if (d1 < 10) {
                digest.update((byte)(d1 + 48));
            } else {
                digest.update((byte)(d1 + 97 - 10));
            }
            if (d2 < 10) {
                digest.update((byte)(d2 + 48));
                continue;
            }
            digest.update((byte)(d2 + 97 - 10));
        }
    }

    protected byte[] stringToDigest(String digest) {
        if (digest == null) {
            return null;
        }
        int len = (digest.length() + 1) / 2;
        byte[] clientDigest = new byte[len];
        int i = 0;
        while (i + 1 < digest.length()) {
            char ch1 = digest.charAt(i);
            char ch2 = digest.charAt(i + 1);
            int b = 0;
            if (ch1 >= '0' && ch1 <= '9') {
                b += ch1 - 48;
            } else if (ch1 >= 'a' && ch1 <= 'f') {
                b += ch1 - 97 + 10;
            }
            b *= 16;
            if (ch2 >= '0' && ch2 <= '9') {
                b += ch2 - 48;
            } else if (ch2 >= 'a' && ch2 <= 'f') {
                b += ch2 - 97 + 10;
            }
            clientDigest[i / 2] = (byte)b;
            i += 2;
        }
        return clientDigest;
    }

    protected byte[] digest(String value) throws ServletException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] data = value.getBytes("UTF8");
            return digest.digest(data);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isMatch(Principal userName, String algorithm, char[] testPassword, char[] systemDigest) {
        char[] testDigest = this.getDigest(userName, algorithm, testPassword, systemDigest);
        boolean isMatch = this.isMatch(testDigest, systemDigest);
        Arrays.fill(testDigest, 'a');
        return isMatch;
    }

    protected char[] getDigest(Principal user, String algorithm, char[] testPassword, char[] systemDigest) {
        char[] digest = DigestBuilder.getDigest(user, algorithm, testPassword, systemDigest);
        if (digest != null) {
            return digest;
        }
        return this.getPasswordDigest(user.getName(), testPassword);
    }

    private boolean isMatch(char[] password, char[] userPassword) {
        int len = password.length;
        if (len != userPassword.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (password[i] == userPassword[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isMatch(byte[] password, byte[] userPassword) {
        int len = password.length;
        if (len != userPassword.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (password[i] == userPassword[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        if (this._passwordDigest != null) {
            return this.getClass().getSimpleName() + "[" + this._passwordDigest.getAlgorithm() + "," + this._passwordDigest.getRealm() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._passwordDigestAlgorithm + "," + this._passwordDigestRealm + "]";
    }
}

