/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.security.AbstractCookieAuthenticator;
import com.caucho.security.AuthenticatedUser;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordCredentials;
import com.caucho.security.PasswordUser;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.security.CachingPrincipal;
import com.caucho.util.L10N;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

public class DatabaseAuthenticator
extends AbstractCookieAuthenticator {
    private static final Logger log = Logger.getLogger(DatabaseAuthenticator.class.getName());
    private static final L10N L = new L10N(DatabaseAuthenticator.class);
    private DataSource _dataSource;
    private String _passwordQuery = "SELECT password FROM LOGIN WHERE username=?";
    private String _cookieUpdate = "UPDATE LOGIN SET cookie=? WHERE username=?";
    private String _cookieQuery = "SELECT username FROM LOGIN where cookie=?";
    private boolean _cookieLogout;
    private String _roleQuery;
    protected boolean _useCookie;
    private String _authCookieName = "resinauthid";
    protected int _cookieVersion = -1;
    protected String _cookieDomain;
    protected long _cookieMaxAge = 31536000000L;

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getPasswordQuery() {
        return this._passwordQuery;
    }

    public void setPasswordQuery(String query) {
        this._passwordQuery = query;
    }

    public String getCookieAuthQuery() {
        return this._cookieQuery;
    }

    public void setCookieAuthQuery(String query) {
        this._cookieQuery = query;
    }

    public String getCookieAuthUpdate() {
        return this._cookieUpdate;
    }

    public void setCookieAuthUpdate(String query) {
        this._cookieUpdate = query;
    }

    public void setCookieLogout(boolean cookieLogout) {
        this._cookieLogout = cookieLogout;
    }

    public String getRoleQuery() {
        return this._roleQuery;
    }

    public void setRoleQuery(String query) {
        this._roleQuery = query;
    }

    public boolean getUseCookie() {
        return this._useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this._useCookie = useCookie;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int version) {
        this._cookieVersion = version;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this._cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period cookieMaxAge) {
        this._cookieMaxAge = cookieMaxAge.getPeriod();
    }

    @Override
    @PostConstruct
    public void init() throws ServletException {
        super.init();
        if (this._dataSource == null) {
            throw new ConfigException(L.l("JdbcAuthenticator requires a 'data-source' attribute, because it depends on a JDBC database"));
        }
        int i = this._passwordQuery.indexOf(63);
        if (i < 0) {
            throw new ConfigException(L.l("'password-query' expects a parameter"));
        }
        if (this._cookieQuery != null && (i = this._cookieQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'cookie-auth-query' expects a parameter"));
        }
        if (this._cookieUpdate != null) {
            i = this._cookieUpdate.indexOf(63);
            if (i < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters for the cookie id and the user id."));
            }
            int j = this._cookieUpdate.indexOf(63, i + 1);
            if (j < 0) {
                throw new ConfigException(L.l("'cookie-auth-update' expects two parameters"));
            }
        }
        if (this._cookieUpdate != null && this._cookieQuery == null) {
            throw new ServletConfigException(L.l("<cookie-auth-update> expects 'cookie-query' because both update and select queries are needed."));
        }
        if (this._roleQuery != null && (i = this._roleQuery.indexOf(63)) < 0) {
            throw new ConfigException(L.l("'role-query' expects a parameter"));
        }
    }

    @Override
    protected Principal authenticate(Principal principal, PasswordCredentials cred, Object details) {
        char[] password = cred.getPassword();
        char[] digest = this.getPasswordDigest(principal.getName(), password);
        return this.authenticate(principal.getName(), new String(digest), (HttpServletRequest)details);
    }

    public Principal authenticate(String username, String password, HttpServletRequest request) {
        Principal user = this.loginImpl(username, password);
        if (this._cookieQuery == null || user == null) {
            return user;
        }
        String cookieAuth = (String)request.getAttribute("j_use_cookie_auth");
        if (cookieAuth == null) {
            cookieAuth = request.getParameter("j_use_cookie_auth");
        }
        if ("true".equals(cookieAuth) || "on".equals(cookieAuth) || this._useCookie && cookieAuth == null) {
            this.addAuthCookie(user, request);
        }
        return user;
    }

    @Override
    public boolean isCookieSupported(String jUseCookieAuth) {
        if (this._cookieQuery == null) {
            return false;
        }
        if ("false".equals(jUseCookieAuth) || "off".equals(jUseCookieAuth)) {
            return false;
        }
        if (this._useCookie) {
            return true;
        }
        return "true".equals(jUseCookieAuth) || "on".equals(jUseCookieAuth);
    }

    protected void addAuthCookie(Principal user, HttpServletRequest request) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal loginImpl(String username, String password) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                Principal principal = null;
                return principal;
            }
            String dbPassword = rs.getString(1);
            if (dbPassword != null && dbPassword.equals(password)) {
                CachingPrincipal cachingPrincipal = new CachingPrincipal(username);
                return cachingPrincipal;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("mismatched password:" + username);
            }
            Principal principal = null;
            return principal;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    protected PasswordUser getPasswordUser(String username) {
        PasswordUser passwordUser;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("no such user:" + username);
                }
                PasswordUser passwordUser2 = null;
                return passwordUser2;
            }
            String dbPassword = rs.getString(1);
            passwordUser = new PasswordUser(new BasicPrincipal(username), dbPassword.toCharArray(), false, false, new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return passwordUser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Principal authenticateByCookie(String cookieValue) {
        if (this._cookieQuery == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieQuery);
            stmt.setString(1, cookieValue);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                Principal principal = null;
                return principal;
            }
            String user = rs.getString(1);
            if (user != null) {
                CachingPrincipal cachingPrincipal = new CachingPrincipal(user);
                return cachingPrincipal;
            }
            Principal principal = null;
            return principal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean associateCookie(Principal user, String cookieValue) {
        if (this._cookieUpdate == null || user == null || cookieValue == null) {
            return true;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._cookieUpdate);
            stmt.setString(1, cookieValue);
            stmt.setString(2, user.getName());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserInRole(Principal principal, String role) {
        Boolean isInRole;
        if (this._roleQuery == null) {
            return principal != null && "user".equals(role);
        }
        if (principal == null || role == null) {
            return false;
        }
        CachingPrincipal cachingPrincipal = null;
        if (principal instanceof CachingPrincipal && (isInRole = (cachingPrincipal = (CachingPrincipal)principal).isInRole(role)) != null) {
            return isInRole.equals(Boolean.TRUE);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this._dataSource.getConnection();
            stmt = conn.prepareStatement(this._roleQuery);
            stmt.setString(1, principal.getName());
            boolean inRole = false;
            rs = stmt.executeQuery();
            while (rs.next()) {
                String dbRole = rs.getString(1);
                if (cachingPrincipal != null) {
                    cachingPrincipal.addRole(dbRole);
                }
                if (!role.equals(dbRole)) continue;
                inRole = true;
            }
            boolean bl = inRole;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    class JdbcUser
    implements AuthenticatedUser {
        private Principal _user;

        JdbcUser(Principal user) {
            this._user = user;
        }

        @Override
        public String getName() {
            return this._user.getName();
        }

        @Override
        public Principal getPrincipal() {
            return this._user;
        }

        @Override
        public boolean isUserInRole(String role) {
            return DatabaseAuthenticator.this.isUserInRole(this._user, role);
        }

        @Override
        public void logout() {
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getName() + "]";
        }
    }
}

