/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Service;
import com.caucho.security.SingleSignon;
import com.caucho.util.LruCache;
import java.security.Principal;
import javax.annotation.PostConstruct;

@Service
public class MemorySingleSignon
implements SingleSignon {
    private int _cacheSize = 4096;
    private LruCache<String, Principal> _cache;

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(int size) {
        this._cacheSize = size;
    }

    @PostConstruct
    public void init() {
        if (this._cacheSize > 0) {
            this._cache = new LruCache(this._cacheSize);
        }
    }

    @Override
    public Principal get(String id) {
        if (this._cache != null) {
            return this._cache.get(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String id, Principal user) {
        LruCache<String, Principal> lruCache = this._cache;
        synchronized (lruCache) {
            this._cache.put(id, user);
        }
    }

    @Override
    public boolean remove(String id) {
        this._cache.remove(id);
        return false;
    }
}

