/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.config.Service;
import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordUser;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;

@Service
public class PropertiesAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Logger.getLogger(PropertiesAuthenticator.class.getName());
    private Path _path;
    private Hashtable<String, PasswordUser> _userMap = new Hashtable();
    private Depend _depend;
    private long _lastCheck;

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setValue(Properties value) {
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            String name = (String)entry.getKey();
            String userValue = (String)entry.getValue();
            this._userMap.put(name, this.createUser(name, userValue));
        }
    }

    public void addUser(String name, String password) {
        this._userMap.put(name, this.createUser(name, password));
    }

    @Override
    @PostConstruct
    public synchronized void init() throws ServletException {
        super.init();
        this.reload();
    }

    @Override
    protected PasswordUser getPasswordUser(String userName) {
        PasswordUser user;
        if (userName == null) {
            return null;
        }
        if (this.isModified()) {
            this.reload();
        }
        if ((user = this._userMap.get(userName)) != null) {
            return user.copy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload() {
        if (this._path == null) {
            return;
        }
        PropertiesAuthenticator propertiesAuthenticator = this;
        synchronized (propertiesAuthenticator) {
            try {
                this._lastCheck = CurrentTime.getCurrentTime();
                this._depend = new Depend(this._path);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " loading users from " + this._path);
                }
                this._userMap = new Hashtable();
                Properties props = new Properties();
                ReadStream is = this._path.openRead();
                try {
                    props.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                this.setValue(props);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
    }

    protected PasswordUser createUser(String name, String value) {
        String[] values = value.trim().split("[,]");
        BasicPrincipal principal = new BasicPrincipal(name);
        if (values.length < 1) {
            return new PasswordUser(principal, new char[0], true, false, new String[0]);
        }
        String password = values[0].trim();
        boolean isDisabled = false;
        boolean isAnonymous = false;
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 1; i < values.length; ++i) {
            String item = values[i].trim();
            if (item.equals("disabled")) {
                isDisabled = true;
                continue;
            }
            if (item.equals("")) continue;
            roles.add(item);
        }
        if (roles.size() == 0) {
            roles.add("user");
        }
        String[] roleArray = new String[roles.size()];
        roles.toArray(roleArray);
        return new PasswordUser(principal, password.toCharArray(), isDisabled, isAnonymous, roleArray);
    }

    private boolean isModified() {
        if (this._path == null) {
            return false;
        }
        if (this._depend == null) {
            return true;
        }
        if (CurrentTime.getCurrentTime() < this._lastCheck + 5000L) {
            return false;
        }
        this._lastCheck = CurrentTime.getCurrentTime();
        return this._depend.isModified();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        boolean hasValue = false;
        if (this.getPath() != null) {
            hasValue = true;
            sb.append(this.getPath());
        }
        if (this.getPasswordDigest() != null) {
            if (!hasValue) {
                sb.append(",");
            }
            sb.append(this.getPasswordDigest());
        }
        sb.append("]");
        return sb.toString();
    }
}

