/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.ConfigException;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.TransactionLog;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.logging.Logger;

public class TransactionManager {
    private static L10N L = new L10N(TransactionManager.class);
    private static Logger log = Logger.getLogger(TransactionManager.class.getName());
    private final Management _management;
    private final Resin _resin;
    private final Path _path;
    private TransactionLog _transactionLog;

    public TransactionManager(Management management) {
        this._management = management;
        this._resin = null;
        this._path = null;
    }

    @Deprecated
    public TransactionManager(Resin resin) {
        this._management = null;
        this._resin = resin;
        this._path = null;
    }

    @Deprecated
    public TransactionManager(Path path) {
        this._management = null;
        this._resin = null;
        this._path = path;
    }

    public Path getPath() {
        if (this._resin != null) {
            return this._resin.getResinDataDirectory();
        }
        if (this._path != null) {
            return this._path;
        }
        return Vfs.lookup("resin-data");
    }

    public TransactionLog createTransactionLog() throws ConfigException {
        if (this._transactionLog == null) {
            this._transactionLog = new TransactionLog(this);
        }
        return this._transactionLog;
    }

    public void start() throws ConfigException {
        if (this._transactionLog != null) {
            this._transactionLog.start();
        }
    }

    public void destroy() {
        TransactionLog transactionLog = this._transactionLog;
        this._transactionLog = null;
        if (transactionLog != null) {
            transactionLog.destroy();
        }
    }
}

