/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.server.distcache.DataStore;
import com.caucho.util.CurrentTime;
import java.util.concurrent.LinkedBlockingQueue;

public class DataRemoveActor
extends AbstractTaskWorker {
    private final DataStore _dataStore;
    private final String _serverId;
    private final int _queueMax = 65536;
    private final LinkedBlockingQueue<RemoveItem> _queue = new LinkedBlockingQueue();

    DataRemoveActor(DataStore dataStore) {
        this._serverId = ResinSystem.getCurrentId();
        this._dataStore = dataStore;
    }

    public void offer(DataStore.DataItem dataItem) {
        RemoveItem item = new RemoveItem(dataItem);
        this._queue.offer(item);
        this.wake();
    }

    @Override
    public long runTask() {
        RemoveItem item;
        DataStore dataStore = this._dataStore;
        long now = CurrentTime.getCurrentTime();
        while ((item = this._queue.peek()) != null) {
            if (now < item.getExpireTime() && this._queue.size() < 65536) {
                return item.getExpireTime() - now;
            }
            if (now < item.getShortExpireTime()) {
                return item.getShortExpireTime() - now;
            }
            item = this._queue.poll();
            if (dataStore.isClosed()) {
                return 0L;
            }
            if (item == null) continue;
            this._dataStore.remove(item.getId(), item.getTime());
        }
        return 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    static final class RemoveItem {
        private final DataStore.DataItem _dataItem;
        private final long _shortExpireTime;
        private final long _expireTime;

        RemoveItem(DataStore.DataItem dataItem) {
            long delta = 10000L;
            if (CurrentTime.isTest()) {
                delta = 500L;
            }
            this._dataItem = dataItem;
            long now = CurrentTime.getCurrentTime();
            this._expireTime = now + delta;
            this._shortExpireTime = now + 1000L;
        }

        public long getId() {
            return this._dataItem.getId();
        }

        public long getTime() {
            return this._dataItem.getTime();
        }

        public long getExpireTime() {
            return this._expireTime;
        }

        public long getShortExpireTime() {
            return this._shortExpireTime;
        }
    }
}

