/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.server.distcache.CacheLoaderCallback;
import com.caucho.server.distcache.DistCacheEntry;
import java.util.concurrent.locks.LockSupport;

class DistCacheEntryLoadCallback
implements CacheLoaderCallback {
    private volatile Thread _thread;
    private volatile boolean _isDone;
    private volatile boolean _isValue;

    DistCacheEntryLoadCallback() {
    }

    @Override
    public void onLoad(DistCacheEntry entry, Object value) {
        if (value != null) {
            entry.putInternal(value);
        }
        this._isValue = !entry.getMnodeEntry().isValueNull();
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public void onLoadFail(DistCacheEntry entry) {
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean get() {
        this._thread = Thread.currentThread();
        try {
            long expire = System.currentTimeMillis() + 60000L;
            while (!this._isDone && System.currentTimeMillis() < expire) {
                LockSupport.parkUntil(expire);
            }
            boolean bl = this._isValue;
            return bl;
        }
        finally {
            this._thread = null;
        }
    }
}

