/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.config.scope.ScopeRemoveListener;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.remote.websocket.MaskedFrameInputStream;
import com.caucho.remote.websocket.UnmaskedFrameInputStream;
import com.caucho.security.Login;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.AbstractCauchoRequest;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AsyncContextImpl;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.WebSocketContextImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketListener;
import com.caucho.websocket.WebSocketServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;

public final class HttpServletRequestImpl
extends AbstractCauchoRequest
implements CauchoRequest,
WebSocketServletRequest {
    private static final Logger log = Logger.getLogger(HttpServletRequestImpl.class.getName());
    private static final L10N L = new L10N(HttpServletRequestImpl.class);
    private AbstractHttpRequest _request;
    private final HttpServletResponseImpl _response;
    private Boolean _isSecure;
    private Invocation _invocation;
    private Cookie[] _cookiesIn;
    private boolean _varyCookies;
    private boolean _hasCookie;
    private boolean _isSessionIdFromCookie;
    private String _runAs;
    private boolean _isLoginRequested;
    private boolean _hasReader;
    private boolean _hasInputStream;
    private HashMapImpl<String, Object> _attributes;
    private boolean _isSyntheticCacheHeader;
    private long _asyncTimeout;
    private AsyncContextImpl _asyncContext;
    private ArrayList<Path> _closeOnExit;

    public HttpServletRequestImpl(AbstractHttpRequest request) {
        this._request = request;
        this._response = new HttpServletResponseImpl(this, request.getAbstractHttpResponse());
    }

    @Override
    public HttpServletResponseImpl getResponse() {
        return this._response;
    }

    public String getProtocol() {
        return this._request.getProtocol();
    }

    public String getScheme() {
        String scheme = this._request.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return this.isSecure() ? "https" : "http";
        }
        return scheme;
    }

    public String getServerName() {
        AbstractHttpRequest request = this._request;
        return request != null ? request.getServerName() : null;
    }

    public int getServerPort() {
        AbstractHttpRequest request = this._request;
        return request != null ? request.getServerPort() : 0;
    }

    public String getRemoteAddr() {
        AbstractHttpRequest request = this._request;
        return request != null ? request.getRemoteAddr() : null;
    }

    public String getRemoteHost() {
        AbstractHttpRequest request = this._request;
        return request != null ? request.getRemoteHost() : null;
    }

    public int getRemotePort() {
        AbstractHttpRequest request = this._request;
        return request != null ? request.getRemotePort() : 0;
    }

    public String getLocalAddr() {
        return this._request.getLocalHost();
    }

    public String getLocalName() {
        return this._request.getLocalHost();
    }

    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._request.setCharacterEncoding(encoding);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._hasReader) {
            throw new IllegalStateException(L.l("getInputStream() can't be called after getReader()"));
        }
        this._hasInputStream = true;
        return this._request.getInputStream();
    }

    public BufferedReader getReader() throws IOException, IllegalStateException {
        if (this._hasInputStream) {
            throw new IllegalStateException(L.l("getReader() can't be called after getInputStream()"));
        }
        this._hasReader = true;
        return this._request.getReader();
    }

    public String getCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this._request.getContentLength();
    }

    public String getContentType() {
        AbstractHttpRequest request = this._request;
        if (request != null) {
            return request.getContentType();
        }
        return null;
    }

    public Locale getLocale() {
        AbstractHttpRequest request = this._request;
        if (request != null) {
            return request.getLocale();
        }
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        AbstractHttpRequest request = this._request;
        if (request != null) {
            return request.getLocales();
        }
        return new Vector().elements();
    }

    public boolean isSecure() {
        Boolean isSecure;
        if (this._isSecure != null) {
            return this._isSecure;
        }
        AbstractHttpRequest request = this._request;
        if (request == null) {
            return false;
        }
        WebApp webApp = request.getWebApp();
        if (webApp != null && (isSecure = webApp.isRequestSecure()) != null) {
            return isSecure;
        }
        return request.isSecure();
    }

    public Object getAttribute(String name) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            return attributes.get(name);
        }
        if (this.isSecure()) {
            attributes = this._attributes = new HashMapImpl();
            this._request.initAttributes(this);
            return attributes.get(name);
        }
        return null;
    }

    private boolean isAttributesEmpty() {
        return this._attributes == null;
    }

    public Enumeration<String> getAttributeNames() {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            return Collections.enumeration(attributes.keySet());
        }
        if (this.isSecure()) {
            attributes = this._attributes = new HashMapImpl();
            this._request.initAttributes(this);
            return Collections.enumeration(attributes.keySet());
        }
        return NullEnumeration.create();
    }

    public void setAttribute(String name, Object value) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (value != null) {
            if (attributes == null) {
                this._attributes = attributes = new HashMapImpl();
                this._request.initAttributes(this);
            }
            Object oldValue = attributes.put(name, value);
            WebApp webApp = this.getWebApp();
            if (webApp != null) {
                for (ServletRequestAttributeListener listener : webApp.getRequestAttributeListeners()) {
                    ServletRequestAttributeEvent event;
                    if (oldValue != null) {
                        event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, oldValue);
                        listener.attributeReplaced(event);
                        continue;
                    }
                    event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, value);
                    listener.attributeAdded(event);
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes == null) {
            return;
        }
        Object oldValue = attributes.remove(name);
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        for (ServletRequestAttributeListener listener : webApp.getRequestAttributeListeners()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, oldValue);
            listener.attributeRemoved(event);
        }
        if (oldValue instanceof ScopeRemoveListener) {
            ((ScopeRemoveListener)oldValue).removeEvent(this, name);
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp webApp = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (webApp != null) {
            return webApp.getRequestDispatcher(cb.toString());
        }
        return null;
    }

    public ServletContext getServletContext() {
        Invocation invocation = this._invocation;
        if (invocation != null) {
            return invocation.getWebApp();
        }
        return null;
    }

    @Override
    public ServletResponse getServletResponse() {
        return this._response;
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public String getRequestURI() {
        if (this._invocation != null) {
            return this._invocation.getRawURI();
        }
        return "";
    }

    @Override
    public String getPageURI() {
        return this._invocation.getRawURI();
    }

    public String getContextPath() {
        if (this._invocation != null) {
            return this._invocation.getContextPath();
        }
        return "";
    }

    @Override
    public String getPageContextPath() {
        return this.getContextPath();
    }

    public String getServletPath() {
        if (this._invocation != null) {
            return this._invocation.getServletPath();
        }
        return "";
    }

    @Override
    public String getPageServletPath() {
        if (this._invocation != null) {
            return this._invocation.getServletPath();
        }
        return "";
    }

    public String getPathInfo() {
        if (this._invocation != null) {
            return this._invocation.getPathInfo();
        }
        return null;
    }

    @Override
    public String getPagePathInfo() {
        if (this._invocation != null) {
            return this._invocation.getPathInfo();
        }
        return null;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    @Override
    public String getRealPath(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this._invocation.getWebApp().getRealPath(path);
        }
        String uri = this.getPageURI();
        String context = this.getPageContextPath();
        if (context != null) {
            uri = uri.substring(context.length());
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = uri.substring(0, p + 1) + path;
        }
        return this._invocation.getWebApp().getRealPath(path);
    }

    @Override
    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        if (this._invocation != null) {
            return this._invocation.getQueryString();
        }
        return null;
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    public String getHeader(String name) {
        return this._request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this._request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._request.getIntHeader(name);
    }

    public long getDateHeader(String name) {
        return this._request.getDateHeader(name);
    }

    public Cookie[] getCookies() {
        Cookie[] cookiesIn = this._cookiesIn;
        if (cookiesIn == null) {
            AbstractHttpRequest request = this._request;
            if (request == null) {
                return null;
            }
            SessionManager sessionManager = this.getSessionManager();
            if (sessionManager == null) {
                return null;
            }
            cookiesIn = request.getCookies();
            String sessionCookieName = this.getSessionCookie(sessionManager);
            for (int i = 0; i < cookiesIn.length; ++i) {
                Cookie cookie = cookiesIn[i];
                if (!cookie.getName().equals(sessionCookieName) || !sessionManager.isSecure()) continue;
                cookie.setSecure(true);
                break;
            }
            this._cookiesIn = cookiesIn;
        }
        if (cookiesIn != null && cookiesIn.length > 0) {
            return cookiesIn;
        }
        return null;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.findCookie(name);
    }

    private Cookie findCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            this.setHasCookie();
            return cookie;
        }
        return null;
    }

    public String getRequestedSessionId() {
        String id;
        SessionManager manager = this.getSessionManager();
        if (manager != null && manager.enableSessionCookies()) {
            this.setVaryCookie(this.getSessionCookie(manager));
            id = this.findSessionIdFromCookie();
            if (id != null) {
                this._isSessionIdFromCookie = true;
                this.setHasCookie();
                return id;
            }
        }
        if ((id = this.findSessionIdFromUrl()) != null) {
            return id;
        }
        if (manager != null && manager.enableSessionCookies()) {
            return null;
        }
        return this._request.findSessionIdFromConnection();
    }

    protected String findSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        if (manager == null || !manager.enableSessionCookies()) {
            return null;
        }
        Cookie cookie = this.getCookie(this.getSessionCookie(manager));
        if (cookie != null) {
            this._isSessionIdFromCookie = true;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public boolean isSessionIdFromCookie() {
        return this._isSessionIdFromCookie;
    }

    @Override
    public String getSessionId() {
        String sessionId = this.getResponse().getSessionId();
        if (sessionId != null) {
            return sessionId;
        }
        return this.getRequestedSessionId();
    }

    @Override
    public void setSessionId(String sessionId) {
        this.getResponse().setSessionId(sessionId);
    }

    private String findSessionIdFromUrl() {
        String id;
        String string = id = this._invocation != null ? this._invocation.getSessionId() : null;
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getRequestedSessionIdNoVary() {
        boolean varyCookies = this._varyCookies;
        boolean hasCookie = this._hasCookie;
        boolean privateCache = this._response.getPrivateCache();
        String id = this.getRequestedSessionId();
        this._varyCookies = varyCookies;
        this._hasCookie = hasCookie;
        this._response.setPrivateOrResinCache(privateCache);
        return id;
    }

    @Override
    protected String getRunAs() {
        return this._runAs;
    }

    public String getAuthType() {
        Object login = this.getAttribute("caucho.user.name");
        if (login instanceof X509Certificate) {
            return "CLIENT_CERT";
        }
        WebApp app = this.getWebApp();
        if (app != null && app.getLogin() != null && this.getUserPrincipal() != null) {
            return app.getLogin().getAuthType();
        }
        return null;
    }

    protected Login getLogin() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getLogin();
        }
        return null;
    }

    @Override
    public boolean isLoginRequested() {
        return this._isLoginRequested;
    }

    @Override
    public void requestLogin() {
        this._isLoginRequested = true;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public String getRemoteUser(boolean create) {
        if (this.isAttributesEmpty() && !create) {
            return null;
        }
        Principal user = (Principal)this.getAttribute("caucho.user");
        if (user == null && create) {
            user = this.getUserPrincipal();
        }
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public void logout() {
        Login login = this.getLogin();
        if (login != null) {
            login.logout(this.getUserPrincipal(), this, this.getResponse());
        }
    }

    public void logoutUserPrincipal() {
    }

    public String runAs(String role) {
        String oldRunAs = this._runAs;
        this._runAs = role;
        return oldRunAs;
    }

    public void setSecure(Boolean isSecure) {
        this._isSecure = isSecure;
    }

    @Override
    public ReadStream getStream() throws IOException {
        return this._request.getStream();
    }

    @Override
    public ReadStream getStream(boolean isFlush) throws IOException {
        return this._request.getStream(isFlush);
    }

    @Override
    public int getRequestDepth(int depth) {
        return depth;
    }

    @Override
    public void setHeader(String key, String value) {
        this._request.setHeader(key, value);
    }

    @Override
    public void setSyntheticCacheHeader(boolean isSynthetic) {
        this._isSyntheticCacheHeader = isSynthetic;
    }

    @Override
    public boolean isSyntheticCacheHeader() {
        return this._isSyntheticCacheHeader;
    }

    @Override
    public void setVaryCookie(String cookie) {
        this._varyCookies = true;
    }

    @Override
    public boolean getVaryCookies() {
        return this._varyCookies;
    }

    @Override
    public void setHasCookie() {
        this._hasCookie = true;
    }

    @Override
    public boolean getHasCookie() {
        if (this._hasCookie) {
            return true;
        }
        if (this._invocation != null) {
            return this._invocation.getSessionId() != null;
        }
        return false;
    }

    @Override
    public boolean isTop() {
        return true;
    }

    @Override
    public boolean isComet() {
        return this._request.isCometActive();
    }

    @Override
    public void addCloseOnExit(Path path) {
        if (this._closeOnExit == null) {
            this._closeOnExit = new ArrayList();
        }
        this._closeOnExit.add(path);
    }

    @Override
    public boolean isDuplex() {
        return this._request.isDuplex();
    }

    @Override
    public void killKeepalive(String reason) {
        this._request.killKeepalive(reason);
    }

    @Override
    public boolean isConnectionClosed() {
        return this._request.isConnectionClosed();
    }

    public SocketLink getConnection() {
        return this._request.getConnection();
    }

    @Override
    public AbstractHttpRequest getAbstractHttpRequest() {
        return this._request;
    }

    @Override
    public boolean isSuspend() {
        return this._request.isSuspend();
    }

    @Override
    public boolean hasRequest() {
        return this._request.hasRequest();
    }

    public void setInvocation(Invocation invocation) {
        this._invocation = invocation;
    }

    @Override
    public Invocation getInvocation() {
        return this._invocation;
    }

    public long getStartTime() {
        return this._request.getStartTime();
    }

    public void finishInvocation() {
        this._request.finishInvocation();
    }

    public boolean isAsyncStarted() {
        AsyncContextImpl asyncContext = this._asyncContext;
        if (asyncContext == null) {
            return false;
        }
        return asyncContext.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        Invocation invocation = this._invocation;
        if (invocation != null) {
            return invocation.isAsyncSupported();
        }
        return false;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, (ServletResponse)this._response);
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        boolean isOriginal;
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(L.l("The servlet '{0}' at '{1}' does not support async because the servlet or one of the filters does not support asynchronous mode.  The servlet should be annotated with a @WebServlet(asyncSupported=true) annotation or have a <async-supported> tag in the web.xml.", (Object)this.getServletName(), (Object)this.getServletPath()));
        }
        if (this._request.isCometActive()) {
            throw new IllegalStateException(L.l("startAsync may not be called twice on the same dispatch."));
        }
        boolean bl = isOriginal = request == this && response == this._response;
        if (this._asyncContext == null) {
            this._asyncContext = new AsyncContextImpl(this._request);
            if (this._asyncTimeout > 0L) {
                this._asyncContext.setTimeout(this._asyncTimeout);
            }
        } else {
            this._asyncContext.restart();
        }
        this._asyncContext.init(request, response, isOriginal);
        return this._asyncContext;
    }

    public AsyncContextImpl getAsyncContext() {
        if (this._asyncContext != null) {
            return this._asyncContext;
        }
        throw new IllegalStateException(L.l("getAsyncContext() must be called after asyncStarted() has started a new AsyncContext."));
    }

    @Override
    public WebSocketContext startWebSocket(WebSocketListener listener) throws IOException {
        String method;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " upgrade HTTP to WebSocket " + listener);
        }
        if (!"GET".equals(method = this.getMethod())) {
            this.getResponse().sendError(405);
            throw new IllegalStateException(L.l("HTTP Method must be 'GET', because the WebSocket protocol requires 'GET'.\n  remote-IP: {0}", (Object)this.getRemoteAddr()));
        }
        String connection = this.getHeader("Connection");
        String upgrade = this.getHeader("Upgrade");
        if (!"WebSocket".equalsIgnoreCase(upgrade)) {
            this.getResponse().sendError(400);
            throw new IllegalStateException(L.l("HTTP Upgrade header '{0}' must be 'WebSocket', because the WebSocket protocol requires an Upgrade: WebSocket header.\n  remote-IP: {1}", (Object)upgrade, (Object)this.getRemoteAddr()));
        }
        if (connection == null || connection.toLowerCase().indexOf("upgrade") < 0) {
            this.getResponse().sendError(400);
            throw new IllegalStateException(L.l("HTTP Connection header '{0}' must be 'Upgrade', because the WebSocket protocol requires a Connection: Upgrade header.\n  remote-IP: {1}", (Object)connection, (Object)this.getRemoteAddr()));
        }
        String key = this.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            this.getResponse().sendError(400);
            throw new IllegalStateException(L.l("HTTP Sec-WebSocket-Key header is required, because the WebSocket protocol requires an Origin header.\n  remote-IP: {0}", (Object)this.getRemoteAddr()));
        }
        if (key.length() != 24) {
            this.getResponse().sendError(400);
            throw new IllegalStateException(L.l("HTTP Sec-WebSocket-Key header is invalid '{0}' because it's not a 16-byte value.\n  remote-IP: {1}", (Object)key, (Object)this.getRemoteAddr()));
        }
        String requiredVersion = "13";
        String version = this.getHeader("Sec-WebSocket-Version");
        if (!requiredVersion.equals(version)) {
            this.getResponse().sendError(400);
            throw new IllegalStateException(L.l("HTTP Sec-WebSocket-Version header with value '{0}' is required, because the WebSocket protocol requires an Sec-WebSocket-Version header.\n  remote-IP: {1}", (Object)requiredVersion, (Object)this.getRemoteAddr()));
        }
        String extensions = this.getHeader("Sec-WebSocket-Extensions");
        boolean isMasked = true;
        if (extensions != null && extensions.indexOf("x-unmasked") >= 0) {
            isMasked = false;
        }
        String serverExtensions = null;
        if (!isMasked) {
            serverExtensions = "x-unmasked";
        }
        this._response.setStatus(101);
        this._response.setHeader("Upgrade", "websocket");
        String accept = this.calculateWebSocketAccept(key);
        this._response.setHeader("Sec-WebSocket-Accept", accept);
        if (serverExtensions != null) {
            this._response.setHeader("Sec-WebSocket-Extensions", serverExtensions);
        }
        this._response.setContentLength(0);
        WebSocketContextImpl webSocket = isMasked ? new WebSocketContextImpl(this, this._response, listener, new MaskedFrameInputStream()) : new WebSocketContextImpl(this, this._response, listener, new UnmaskedFrameInputStream());
        SocketLinkDuplexController controller = this._request.startDuplex(webSocket);
        webSocket.setController(controller);
        try {
            this._response.getOutputStream().flush();
            webSocket.flush();
            webSocket.onStart();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return webSocket;
    }

    private String calculateWebSocketAccept(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            int length = key.length();
            for (int i = 0; i < length; ++i) {
                md.update((byte)key.charAt(i));
            }
            String guid = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            length = guid.length();
            for (int i = 0; i < length; ++i) {
                md.update((byte)guid.charAt(i));
            }
            byte[] digest = md.digest();
            return Base64.encode(digest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    int getAvailable() throws IOException {
        if (this._request != null) {
            return this._request.getAvailable();
        }
        return -1;
    }

    int getBufferAvailable() throws IOException {
        if (this._request != null) {
            return this._request.getBufferAvailable();
        }
        return -1;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    @Override
    protected void finishRequest() throws IOException {
        AsyncContextImpl async = this._asyncContext;
        this._asyncContext = null;
        if (async != null) {
            async.onComplete();
        }
        super.finishRequest();
        this.cleanup();
        if (this._closeOnExit != null) {
            for (int i = this._closeOnExit.size() - 1; i >= 0; --i) {
                Path path = this._closeOnExit.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        this._response.closeImpl();
        this._cookiesIn = null;
        this._request = null;
    }

    public void cleanup() {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof ScopeRemoveListener)) continue;
                ((ScopeRemoveListener)value).removeEvent(this, entry.getKey());
            }
        }
    }

    public String getServletName() {
        if (this._invocation != null) {
            return this._invocation.getServletName();
        }
        return null;
    }

    @Override
    public final ServletService getServer() {
        return this._request.getServer();
    }

    @Override
    public final WebApp getWebApp() {
        if (this._invocation != null) {
            return this._invocation.getWebApp();
        }
        return null;
    }

    public boolean isClosed() {
        return this._request == null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._request + "]";
    }
}

