/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.webapp.CauchoFilterChain;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

public class WebAppListenerFilterChain
implements CauchoFilterChain {
    private static final Logger log = Logger.getLogger(WebAppListenerFilterChain.class.getName());
    private FilterChain _next;
    private WebApp _webApp;
    private ServletRequestListener[] _requestListeners;

    public WebAppListenerFilterChain(FilterChain next, WebApp webApp, ServletRequestListener[] requestListeners) {
        this._next = next;
        this._webApp = webApp;
        this._requestListeners = requestListeners;
    }

    @Override
    public FilterChain getNext() {
        return this._next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestEvent event;
        int i;
        try {
            for (i = 0; i < this._requestListeners.length; ++i) {
                event = new ServletRequestEvent((ServletContext)this._webApp, request);
                this._requestListeners[i].requestInitialized(event);
            }
            this._next.doFilter(request, response);
        }
        finally {
            for (i = this._requestListeners.length - 1; i >= 0; --i) {
                try {
                    event = new ServletRequestEvent((ServletContext)this._webApp, request);
                    this._requestListeners[i].requestDestroyed(event);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp.getURL() + ", next=" + this._next + "]";
    }
}

