/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PreparedStatementWrapper
implements PreparedStatement {
    private final PreparedStatement _preparedStatement;
    private ProfilerPoint _profilerPoint;

    public PreparedStatementWrapper(ProfilerPoint profilerPoint, PreparedStatement preparedStatement) {
        this._profilerPoint = profilerPoint;
        this._preparedStatement = preparedStatement;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this._preparedStatement.executeQuery();
            return resultSet;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.executeUpdate();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setNull(parameterIndex, sqlType);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setBoolean(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setByte(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setShort(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setInt(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setLong(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setFloat(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setDouble(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setBigDecimal(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setString(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setBytes(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setDate(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setTime(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setTimestamp(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setAsciiStream(parameterIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setUnicodeStream(parameterIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setBinaryStream(parameterIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.clearParameters();
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setObject(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.execute();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.addBatch();
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int i, Ref x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setRef(i, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setBlob(i, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int i, Clob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setClob(i, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int i, Array x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setArray(i, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSetMetaData resultSetMetaData = this._preparedStatement.getMetaData();
            return resultSetMetaData;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setDate(parameterIndex, x, cal);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setTime(parameterIndex, x, cal);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setTimestamp(parameterIndex, x, cal);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setNull(paramIndex, sqlType, typeName);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setURL(parameterIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ParameterMetaData parameterMetaData = this._preparedStatement.getParameterMetaData();
            return parameterMetaData;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this._preparedStatement.executeQuery(sql);
            return resultSet;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.executeUpdate(sql);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void close() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.close();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getMaxFieldSize();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setMaxFieldSize(max);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getMaxRows();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setMaxRows(max);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setEscapeProcessing(enable);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getQueryTimeout();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setQueryTimeout(seconds);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void cancel() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.cancel();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            SQLWarning sQLWarning = this._preparedStatement.getWarnings();
            return sQLWarning;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.clearWarnings();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setCursorName(name);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.execute(sql);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this._preparedStatement.getResultSet();
            return resultSet;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getUpdateCount();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.getMoreResults();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setFetchDirection(direction);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getFetchDirection();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.setFetchSize(rows);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getFetchSize();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getResultSetConcurrency();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getResultSetType();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.addBatch(sql);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._preparedStatement.clearBatch();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int[] nArray = this._preparedStatement.executeBatch();
            return nArray;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Connection connection = this._preparedStatement.getConnection();
            return connection;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.getMoreResults(current);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSet resultSet = this._preparedStatement.getGeneratedKeys();
            return resultSet;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._preparedStatement.execute(sql, columnNames);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._preparedStatement.getResultSetHoldability();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    public String toString() {
        return "PreparedStatementWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

