/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public final class ResultSetWrapper
implements ResultSet {
    private final ProfilerPoint _profilerPoint;
    private final ResultSet _resultSet;

    public ResultSetWrapper(ProfilerPoint profilerPoint, ResultSet resultSet) {
        this._profilerPoint = profilerPoint;
        this._resultSet = resultSet;
    }

    @Override
    public boolean next() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.next();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void close() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.close();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.wasNull();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            String string = this._resultSet.getString(columnIndex);
            return string;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.getBoolean(columnIndex);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            byte by = this._resultSet.getByte(columnIndex);
            return by;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            short s = this._resultSet.getShort(columnIndex);
            return s;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getInt(columnIndex);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            long l = this._resultSet.getLong(columnIndex);
            return l;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            float f = this._resultSet.getFloat(columnIndex);
            return f;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            double d = this._resultSet.getDouble(columnIndex);
            return d;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            BigDecimal bigDecimal = this._resultSet.getBigDecimal(columnIndex, scale);
            return bigDecimal;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            byte[] byArray = this._resultSet.getBytes(columnIndex);
            return byArray;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Date date = this._resultSet.getDate(columnIndex);
            return date;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Time time = this._resultSet.getTime(columnIndex);
            return time;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Timestamp timestamp = this._resultSet.getTimestamp(columnIndex);
            return timestamp;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getAsciiStream(columnIndex);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getUnicodeStream(columnIndex);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getBinaryStream(columnIndex);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            String string = this._resultSet.getString(columnName);
            return string;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.getBoolean(columnName);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            byte by = this._resultSet.getByte(columnName);
            return by;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            short s = this._resultSet.getShort(columnName);
            return s;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getInt(columnName);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this._resultSet.getLong(columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            float f = this._resultSet.getFloat(columnName);
            return f;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this._resultSet.getDouble(columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            BigDecimal bigDecimal = this._resultSet.getBigDecimal(columnName, scale);
            return bigDecimal;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            byte[] byArray = this._resultSet.getBytes(columnName);
            return byArray;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Date date = this._resultSet.getDate(columnName);
            return date;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Time time = this._resultSet.getTime(columnName);
            return time;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Timestamp timestamp = this._resultSet.getTimestamp(columnName);
            return timestamp;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getAsciiStream(columnName);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getUnicodeStream(columnName);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            InputStream inputStream = this._resultSet.getBinaryStream(columnName);
            return inputStream;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            SQLWarning sQLWarning = this._resultSet.getWarnings();
            return sQLWarning;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.clearWarnings();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            String string = this._resultSet.getCursorName();
            return string;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            ResultSetMetaData resultSetMetaData = this._resultSet.getMetaData();
            return resultSetMetaData;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Object object = this._resultSet.getObject(columnIndex);
            return object;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Object object = this._resultSet.getObject(columnName);
            return object;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.findColumn(columnName);
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Reader reader = this._resultSet.getCharacterStream(columnIndex);
            return reader;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Reader reader = this._resultSet.getCharacterStream(columnName);
            return reader;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            BigDecimal bigDecimal = this._resultSet.getBigDecimal(columnIndex);
            return bigDecimal;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            BigDecimal bigDecimal = this._resultSet.getBigDecimal(columnName);
            return bigDecimal;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.isBeforeFirst();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.isAfterLast();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.isFirst();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.isLast();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.beforeFirst();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.afterLast();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean first() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.first();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean last() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.last();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getRow();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.absolute(row);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.relative(rows);
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean previous() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.previous();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.setFetchDirection(direction);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getFetchDirection();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.setFetchSize(rows);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getFetchSize();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getType() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._resultSet.getType();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._resultSet.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.rowUpdated();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.rowInserted();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._resultSet.rowDeleted();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateNull(columnIndex);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBoolean(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateByte(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateShort(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateInt(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateLong(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateFloat(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateDouble(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBigDecimal(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateString(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBytes(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateDate(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateTime(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateTimestamp(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateAsciiStream(columnIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBinaryStream(columnIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateCharacterStream(columnIndex, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateObject(columnIndex, x, scale);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateObject(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateNull(columnName);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBoolean(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateByte(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateShort(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateInt(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateLong(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this._resultSet.updateFloat(columnName, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateDouble(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBigDecimal(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(String columnName, String x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateString(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBytes(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateDate(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateTime(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateTimestamp(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateAsciiStream(columnName, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBinaryStream(columnName, x, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateCharacterStream(columnName, reader, length);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateObject(columnName, x, scale);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateObject(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void insertRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.insertRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void updateRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.deleteRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.refreshRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.cancelRowUpdates();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.moveToInsertRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.moveToCurrentRow();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Statement statement = this._resultSet.getStatement();
            return statement;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Object object = this._resultSet.getObject(i, map);
            return object;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int i) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Ref ref = this._resultSet.getRef(i);
            return ref;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int i) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Blob blob = this._resultSet.getBlob(i);
            return blob;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int i) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Clob clob = this._resultSet.getClob(i);
            return clob;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int i) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Array array = this._resultSet.getArray(i);
            return array;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Object object = this._resultSet.getObject(colName, map);
            return object;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(String colName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Ref ref = this._resultSet.getRef(colName);
            return ref;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String colName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Blob blob = this._resultSet.getBlob(colName);
            return blob;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String colName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Clob clob = this._resultSet.getClob(colName);
            return clob;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(String colName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Array array = this._resultSet.getArray(colName);
            return array;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Date date = this._resultSet.getDate(columnIndex, cal);
            return date;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Date date = this._resultSet.getDate(columnName, cal);
            return date;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Time time = this._resultSet.getTime(columnIndex, cal);
            return time;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Time time = this._resultSet.getTime(columnName, cal);
            return time;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Timestamp timestamp = this._resultSet.getTimestamp(columnIndex, cal);
            return timestamp;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Timestamp timestamp = this._resultSet.getTimestamp(columnName, cal);
            return timestamp;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            URL uRL = this._resultSet.getURL(columnIndex);
            return uRL;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(String columnName) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            URL uRL = this._resultSet.getURL(columnName);
            return uRL;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateRef(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateRef(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBlob(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateBlob(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateClob(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateClob(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateArray(columnIndex, x);
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._resultSet.updateArray(columnName, x);
        }
        finally {
            profiler.finish();
        }
    }

    public String toString() {
        return "ResultSetWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }
}

