/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import javax.transaction.xa.Xid;

public class XidImpl
implements Xid {
    public static final int GLOBAL_LENGTH = 28;
    private byte[] _global;
    private byte[] _local;

    public XidImpl(long serverId, long randomId, long sequence) {
        this._global = new byte[28];
        this._local = new byte[4];
        this._local[0] = 1;
        this._global[0] = 82;
        this._global[1] = 101;
        this._global[2] = 115;
        this._global[3] = 110;
        this._global[4] = (byte)(serverId >> 56);
        this._global[5] = (byte)(serverId >> 48);
        this._global[6] = (byte)(serverId >> 40);
        this._global[7] = (byte)(serverId >> 32);
        this._global[8] = (byte)(serverId >> 24);
        this._global[9] = (byte)(serverId >> 16);
        this._global[10] = (byte)(serverId >> 8);
        this._global[11] = (byte)serverId;
        this._global[12] = (byte)(randomId >> 56);
        this._global[13] = (byte)(randomId >> 48);
        this._global[14] = (byte)(randomId >> 40);
        this._global[15] = (byte)(randomId >> 32);
        this._global[16] = (byte)(randomId >> 24);
        this._global[17] = (byte)(randomId >> 16);
        this._global[18] = (byte)(randomId >> 8);
        this._global[19] = (byte)randomId;
        this._global[20] = (byte)(sequence >> 56);
        this._global[21] = (byte)(sequence >> 48);
        this._global[22] = (byte)(sequence >> 40);
        this._global[23] = (byte)(sequence >> 32);
        this._global[24] = (byte)(sequence >> 24);
        this._global[25] = (byte)(sequence >> 16);
        this._global[26] = (byte)(sequence >> 8);
        this._global[27] = (byte)sequence;
    }

    XidImpl(XidImpl base, int branch) {
        this._global = new byte[base._global.length];
        this._local = new byte[4];
        this._local[0] = (byte)branch;
        System.arraycopy(base._global, 0, this._global, 0, this._global.length);
    }

    public XidImpl(byte[] global, byte[] local) {
        this._global = new byte[global.length];
        this._local = new byte[local.length];
        System.arraycopy(global, 0, this._global, 0, global.length);
        System.arraycopy(local, 0, this._local, 0, local.length);
    }

    XidImpl(byte[] global) {
        this._global = new byte[global.length];
        this._local = new byte[4];
        System.arraycopy(global, 0, this._global, 0, global.length);
        this._local[0] = 1;
    }

    @Override
    public int getFormatId() {
        return 1234;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this._local;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    boolean isSameServer(long serverId) {
        if (this._global[0] != 82 || this._global[1] != 101 || this._global[2] != 115 || this._global[3] != 110) {
            return false;
        }
        return this._global[4] == (byte)(serverId >> 56) && this._global[5] == (byte)(serverId >> 48) && this._global[6] == (byte)(serverId >> 40) && this._global[7] == (byte)(serverId >> 32) && this._global[8] == (byte)(serverId >> 24) && this._global[9] == (byte)(serverId >> 16) && this._global[10] == (byte)(serverId >> 8) && this._global[11] == (byte)serverId;
    }

    public Object clone() {
        return new XidImpl(this._global, this._local);
    }

    public int hashCode() {
        byte[] global = this._global;
        int hash = 37;
        for (int i = global.length - 1; i >= 0; --i) {
            hash = 65521 * hash + global[i];
        }
        return hash;
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)o;
        byte[] global = xid.getGlobalTransactionId();
        byte[] local = xid.getBranchQualifier();
        if (global.length != this._global.length) {
            return false;
        }
        byte[] selfGlobal = this._global;
        byte[] selfLocal = this._local;
        for (i = global.length - 1; i >= 0; --i) {
            if (global[i] == selfGlobal[i]) continue;
            return false;
        }
        for (i = local.length - 1; i >= 0; --i) {
            if (local[i] == selfLocal[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder cb = new StringBuilder();
        cb.append("Xid");
        cb.append("[");
        byte[] branch = this.getBranchQualifier();
        XidImpl.addByte(cb, branch[0]);
        cb.append(":");
        byte[] global = this.getGlobalTransactionId();
        for (int i = 24; i < 28; ++i) {
            XidImpl.addByte(cb, global[i]);
        }
        cb.append("]");
        return cb.toString();
    }

    private static void addByte(StringBuilder cb, int b) {
        int h = (b &= 0xFF) / 16 & 0xF;
        int l = b & 0xF;
        if (h >= 10) {
            cb.append((char)(97 + h - 10));
        } else {
            cb.append((char)(48 + h));
        }
        if (l >= 10) {
            cb.append((char)(97 + l - 10));
        } else {
            cb.append((char)(48 + l));
        }
    }
}

