/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InetNetwork {
    private static final Logger log = Logger.getLogger(InetNetwork.class.getName());
    private InetAddress _inetAddress;
    private byte[] _address = new byte[8];
    private int _subnetBits;
    private int _subnetByte;
    private int _subnetMask;

    public InetNetwork(InetAddress inetAddress, int subnetBits) {
        this._inetAddress = inetAddress;
        this._address = inetAddress.getAddress();
        if (subnetBits < 0) {
            subnetBits = 8 * this._address.length;
        }
        this._subnetBits = subnetBits;
        this._subnetByte = subnetBits / 8;
        this._subnetMask = ~((1 << 8 - subnetBits % 8) - 1) & 0xFF;
    }

    public static InetNetwork valueOf(String network) throws UnknownHostException {
        return InetNetwork.create(network);
    }

    public static InetNetwork create(String network) throws UnknownHostException {
        if (network == null) {
            return null;
        }
        int subnetBits = -1;
        int p = network.indexOf(47);
        if (p > 0) {
            String subnet = network.substring(p + 1);
            subnetBits = Integer.parseInt(subnet);
            network = network.substring(0, p);
        }
        InetAddress inetAddress = InetAddress.getByName(network);
        return new InetNetwork(inetAddress, subnetBits);
    }

    public boolean isMatch(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        if (bytes.length != this._address.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == this._address[i]) continue;
            if (this._subnetByte < i) {
                return true;
            }
            if (i == this._subnetByte) {
                return (bytes[i] & this._subnetMask) == (this._address[i] & this._subnetMask);
            }
            return false;
        }
        return true;
    }

    public boolean isMatch(String address) {
        try {
            return this.isMatch(InetAddress.getByName(address));
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public String toString() {
        return this._inetAddress + "/" + this._subnetBits;
    }
}

