/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeList;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class Sha256OutputStream
extends OutputStream {
    private static FreeList<MessageDigest> _freeDigestList = new FreeList(16);
    private OutputStream _os;
    private MessageDigest _digest;
    private byte[] _hash;

    public Sha256OutputStream(OutputStream os) {
        this._os = os;
        try {
            this._digest = _freeDigestList.allocate();
            if (this._digest == null) {
                this._digest = MessageDigest.getInstance("SHA-256");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getDigest() {
        return this._hash;
    }

    @Override
    public void write(int value) throws IOException {
        this._os.write(value);
        this._digest.update((byte)value);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._os.write(buffer, offset, length);
        this._digest.update(buffer, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this._os.flush();
    }

    @Override
    public void close() throws IOException {
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            os.close();
        }
        MessageDigest digest = this._digest;
        this._digest = null;
        if (digest != null) {
            this._hash = digest.digest();
            digest.reset();
            _freeDigestList.free(digest);
        }
    }
}

