/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.SchemeRoot;
import java.util.HashMap;

public class SchemeMap {
    private static SchemeMap _nullSchemeMap;
    private final EnvironmentLocal<HashMap<String, SchemeRoot>> _schemeMap = new EnvironmentLocal();

    public SchemeMap() {
        this._schemeMap.set(new HashMap(), null);
    }

    private SchemeMap(HashMap<String, SchemeRoot> map) {
        this.getUpdateMap().putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SchemeMap getNullSchemeMap() {
        Class<SchemeMap> clazz = SchemeMap.class;
        synchronized (SchemeMap.class) {
            if (_nullSchemeMap == null) {
                _nullSchemeMap = new SchemeMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _nullSchemeMap;
        }
    }

    public Path get(String scheme) {
        SchemeRoot root = this.getMap().get(scheme);
        Path path = null;
        if (root != null) {
            path = root.getRoot();
        }
        if (path != null) {
            return path;
        }
        return new NotFoundPath(this, scheme + ":");
    }

    public SchemeRoot getSchemeRoot(String scheme) {
        return this.getMap().get(scheme);
    }

    public Path put(String scheme, Path path) {
        SchemeRoot oldRoot = this.getUpdateMap().put(scheme, new SchemeRoot(path));
        return oldRoot != null ? oldRoot.getRoot() : null;
    }

    public SchemeRoot put(String scheme, SchemeRoot root) {
        return this.getUpdateMap().put(scheme, root);
    }

    public SchemeMap copy() {
        return new SchemeMap(this.getMap());
    }

    public Path remove(String scheme) {
        SchemeRoot oldRoot = this.getUpdateMap().remove(scheme);
        return oldRoot != null ? oldRoot.getRoot() : null;
    }

    private HashMap<String, SchemeRoot> getMap() {
        HashMap<String, SchemeRoot> map = this._schemeMap.get();
        return map;
    }

    private HashMap<String, SchemeRoot> getUpdateMap() {
        HashMap<String, SchemeRoot> map = this._schemeMap.getLevel();
        if (map == null) {
            HashMap<String, SchemeRoot> oldMap = this.getMap();
            map = oldMap != null ? new HashMap<String, SchemeRoot>(oldMap) : new HashMap();
            this._schemeMap.set(map);
        }
        return map;
    }
}

