/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.util.ByteAppendable;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;

public class UTF8Writer
extends EncodingWriter {
    private static final UTF8Writer _writer = new UTF8Writer();

    @Override
    public String getJavaEncoding() {
        return "UTF8";
    }

    @Override
    public EncodingWriter create(String javaEncoding) {
        return _writer;
    }

    @Override
    public EncodingWriter create() {
        return _writer;
    }

    @Override
    public void write(ByteAppendable os, char ch) throws IOException {
        if (ch < '\u0080') {
            os.write(ch);
        } else if (ch < '\u0800') {
            os.write(192 + (ch >> 6));
            os.write(128 + (ch & 0x3F));
        } else {
            os.write(224 + (ch >> 12));
            os.write(128 + (ch >> 6 & 0x3F));
            os.write(128 + (ch & 0x3F));
        }
    }

    @Override
    public int write(OutputStreamWithBuffer os, char[] cbuf, int off, int len) throws IOException {
        byte[] buffer = os.getBuffer();
        int length = os.getBufferOffset();
        int capacity = buffer.length;
        int tail = off + len;
        int head = off;
        while (off < tail) {
            char ch;
            while (capacity - length <= 4) {
                buffer = os.nextBuffer(length);
                length = os.getBufferOffset();
            }
            if ((ch = cbuf[off++]) < '\u0080') {
                buffer[length++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buffer[length++] = (byte)(192 + (ch >> 6));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            if (ch < '\ud800' || '\udfff' < ch) {
                buffer[length++] = (byte)(224 + (ch >> 12));
                buffer[length++] = (byte)(128 + (ch >> 6 & 0x3F));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            if (off == tail) {
                --off;
                break;
            }
            char ch2 = cbuf[off++];
            int v = 65536 + (ch & 0x3FF) * 1024 + (ch2 & 0x3FF);
            buffer[length++] = (byte)(240 + (v >> 18));
            buffer[length++] = (byte)(128 + (v >> 12 & 0x3F));
            buffer[length++] = (byte)(128 + (v >> 6 & 0x3F));
            buffer[length++] = (byte)(128 + (v & 0x3F));
        }
        os.setBufferOffset(length);
        return off - head;
    }
}

