/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.IntMap;
import com.caucho.xml.Entities;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;

class XmlEntities
extends Entities {
    private static Entities _xmlEntities = new XmlEntities();
    private IntMap _entities = new IntMap();

    static Entities create() {
        return _xmlEntities;
    }

    protected XmlEntities() {
        this._entities.put("lt", 60);
        this._entities.put("gt", 62);
        this._entities.put("amp", 38);
        this._entities.put("quot", 34);
        this._entities.put("apos", 39);
    }

    @Override
    int getEntity(String entity) {
        return this._entities.get(entity);
    }

    @Override
    void printText(XmlPrinter os, char[] text, int offset, int length, boolean attr) throws IOException {
        block10: for (int i = 0; i < length; ++i) {
            char ch = text[offset + i];
            switch (ch) {
                case '\t': {
                    os.print(ch);
                    continue block10;
                }
                case '\n': 
                case '\r': {
                    if (!attr) {
                        os.print(ch);
                        continue block10;
                    }
                    os.print("&#");
                    os.print((int)ch);
                    os.print(";");
                    continue block10;
                }
                case '<': {
                    os.print("&lt;");
                    continue block10;
                }
                case '>': {
                    os.print("&gt;");
                    continue block10;
                }
                case '&': {
                    os.print("&amp;");
                    continue block10;
                }
                case '\"': {
                    if (attr) {
                        os.print("&quot;");
                        continue block10;
                    }
                    os.print('\"');
                    continue block10;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f' || XmlChar.isChar(ch)) {
                        try {
                            os.print(ch);
                        }
                        catch (IOException e) {
                            os.print("&#");
                            os.print((int)ch);
                            os.print(';');
                        }
                        continue block10;
                    }
                    os.print("&#");
                    os.print((int)ch);
                    os.print(';');
                }
            }
        }
    }
}

