/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.xml2.NamespaceBinding;
import com.caucho.xml2.NamespaceContextImpl;
import javax.xml.namespace.QName;

public class SaxIntern {
    private static final int SIZE = 203;
    private final Entry[] _entries = new Entry[203];
    private final NamespaceContextImpl _namespaceContext;

    SaxIntern(NamespaceContextImpl namespaceContext) {
        this._namespaceContext = namespaceContext;
    }

    Entry add(char[] buffer, int offset, int length, int colon, boolean isAttribute) {
        int hash = 0;
        for (int i = length - 1; i >= 0; --i) {
            hash = 37 * hash + buffer[offset + i];
        }
        int bucket = (hash & Integer.MAX_VALUE) % 203;
        Entry entry = this._entries[bucket];
        while (entry != null) {
            if (entry.match(buffer, offset, length, isAttribute)) {
                return entry;
            }
            entry = entry._next;
        }
        this._entries[bucket] = entry = new Entry(this._entries[bucket], buffer, offset, length, colon, isAttribute);
        return entry;
    }

    final class Entry {
        final Entry _next;
        final char[] _buf;
        final boolean _isAttribute;
        final String _prefix;
        final String _localName;
        final boolean _isXmlns;
        String _name;
        NamespaceBinding _namespace;
        int _version;
        QName _qName;

        Entry(Entry next, char[] buf, int offset, int length, int colon, boolean isAttribute) {
            this._next = next;
            this._buf = new char[length];
            System.arraycopy(buf, offset, this._buf, 0, length);
            this._isAttribute = isAttribute;
            if (colon > offset) {
                this._prefix = new String(buf, offset, colon - offset);
                this._localName = new String(buf, colon + 1, length - colon - 1);
                this._isXmlns = isAttribute && colon == 5 && "xmlns".equals(this._prefix);
            } else {
                this._prefix = null;
                this._localName = new String(buf, 0, length);
                this._isXmlns = isAttribute && length == 5 && "xmlns".equals(this._localName);
            }
            this._namespace = this._isAttribute ? SaxIntern.this._namespaceContext.getAttributeNamespace(this._prefix) : SaxIntern.this._namespaceContext.getElementNamespace(this._prefix);
            this.fillQName();
        }

        public final boolean match(char[] buf, int offset, int length, boolean isAttribute) {
            if (length != this._buf.length || this._isAttribute != isAttribute) {
                return false;
            }
            char[] entryBuf = this._buf;
            --length;
            while (length >= 0) {
                if (entryBuf[length] != buf[offset + length]) {
                    return false;
                }
                --length;
            }
            return true;
        }

        String getName() {
            if (this._name == null) {
                this._name = new String(this._buf, 0, this._buf.length);
            }
            return this._name;
        }

        String getLocalName() {
            return this._localName;
        }

        String getPrefix() {
            return this._prefix;
        }

        String getUri() {
            return this._namespace.getUri();
        }

        QName getQName() {
            if (this._version != this._namespace.getVersion()) {
                this.fillQName();
            }
            return this._qName;
        }

        boolean isXmlns() {
            return this._isXmlns;
        }

        private void fillQName() {
            this._version = this._namespace.getVersion();
            String prefix = this._prefix;
            if (prefix == null) {
                prefix = "";
            }
            this._qName = new QName(this._namespace.getUri(), this._localName, prefix);
        }
    }
}

