/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.vfs.Path;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class CacheableDocument {
    private ArrayList depends;
    private Document document;

    CacheableDocument(Document document, ArrayList depends) {
        this.document = document;
        this.depends = depends;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isCacheable() {
        return this.depends != null;
    }

    public long getLastModified() {
        if (this.depends == null) {
            return 0L;
        }
        long lastModified = 0L;
        for (int i = 0; i < this.depends.size(); ++i) {
            Path path = (Path)this.depends.get(i);
            long time = path.getLastModified();
            if (time <= lastModified) continue;
            lastModified = time;
        }
        return lastModified;
    }

    public ArrayList getCacheDepends() {
        return this.depends;
    }

    void addDepend(Path path) {
        if (this.depends != null) {
            this.depends.add(path);
        }
    }
}

