/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.xml.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.helpers.DefaultHandler;

public class XmlStylesheetReader
extends DefaultHandler {
    private ArrayList _stylesheets = new ArrayList();

    @Override
    public void processingInstruction(String name, String value) {
        if (!name.equals("xml-stylesheet")) {
            return;
        }
        try {
            HashMap<String, String> values = XmlUtil.splitNameList(value);
            String href = values.get("href");
            String media = values.get("media");
            String title = values.get("title");
            String charset = values.get("charset");
            if (href == null) {
                return;
            }
            this._stylesheets.add(new XmlStylesheet(href, media, title, charset));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAssociatedStylesheet(String media, String title, String charset) {
        String best = null;
        int bestCost = -1;
        for (int i = 0; i < this._stylesheets.size(); ++i) {
            XmlStylesheet ss = (XmlStylesheet)this._stylesheets.get(i);
            int cost = ss.match(media, title, charset);
            if (cost <= bestCost) continue;
            bestCost = cost;
            best = ss.getSystemId();
        }
        return best;
    }

    static class XmlStylesheet {
        private String _systemId;
        private String _media;
        private String _title;
        private String _charset;

        XmlStylesheet(String systemId, String media, String title, String charset) {
            this._systemId = systemId;
            this._media = media;
            this._title = title;
            this._charset = charset;
        }

        public String getSystemId() {
            return this._systemId;
        }

        public int match(String media, String title, String charset) {
            int cost = 1;
            if (this._media != null && this._media.equals(media)) {
                ++cost;
            } else {
                if (this._media != null && !this._media.equals(media)) {
                    return -1;
                }
                if (this._media == null && media == null) {
                    ++cost;
                }
            }
            if (this._title != null && this._title.equals(title)) {
                ++cost;
            } else {
                if (this._title != null && !this._title.equals(title)) {
                    return -1;
                }
                if (this._title == null && title == null) {
                    ++cost;
                }
            }
            if (this._charset != null && this._charset.equals(charset)) {
                ++cost;
            } else {
                if (this._charset != null && !this._charset.equals(charset)) {
                    return -1;
                }
                if (this._charset == null && charset == null) {
                    ++cost;
                }
            }
            return cost;
        }
    }
}

