/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.thread;

import com.caucho.admin.thread.ThreadSnapshot;
import com.caucho.admin.thread.filter.ThreadSnapshotFilter;
import java.util.ArrayList;
import java.util.List;

public class ThreadActivityGroup {
    private final String _name;
    private final List<ThreadSnapshotFilter> _filters = new ArrayList<ThreadSnapshotFilter>();
    private final List<ThreadSnapshot> _threads = new ArrayList<ThreadSnapshot>();

    public ThreadActivityGroup(String name) {
        this._name = name;
    }

    public ThreadActivityGroup(String name, ThreadSnapshotFilter filter) {
        this(name);
        this._filters.add(filter);
    }

    public void addFilter(ThreadSnapshotFilter filter) {
        this._filters.add(filter);
    }

    public String getName() {
        return this._name;
    }

    public boolean addIfMatches(ThreadSnapshot thread) {
        for (ThreadSnapshotFilter filter : this._filters) {
            if (filter.isMatch(thread)) continue;
            return false;
        }
        this._threads.add(thread);
        return true;
    }

    public String toScoreboard() {
        StringBuilder sb = new StringBuilder();
        for (ThreadSnapshot thread : this._threads) {
            sb.append(thread.getCode());
        }
        return sb.toString();
    }
}

