/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractTableConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import java.util.HashMap;
import javax.persistence.CollectionTable;
import javax.persistence.JoinColumn;

public class CollectionTableConfig
extends AbstractTableConfig {
    private HashMap<String, JoinColumnConfig> _joinColumnMap = new HashMap();

    public CollectionTableConfig() {
    }

    public CollectionTableConfig(String sourceName, String fieldName) {
        this.setName(sourceName + "_" + fieldName);
    }

    public CollectionTableConfig(CollectionTable joinTable) {
        this.setName(joinTable.name());
        this.setCatalog(joinTable.catalog());
        this.setSchema(joinTable.schema());
        for (JoinColumn joinColumn : joinTable.joinColumns()) {
            JoinColumnConfig joinColumnConfig = new JoinColumnConfig(joinColumn);
            this.addJoinColumn(joinColumnConfig);
        }
    }

    public JoinColumnConfig getJoinColumn(String name) {
        return this._joinColumnMap.get(name);
    }

    public void addJoinColumn(JoinColumnConfig joinColumn) {
        this._joinColumnMap.put(joinColumn.getName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }
}

