/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.config.inject.HandleAware;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;

public class EntityManagerProxy
implements EntityManager,
Serializable,
HandleAware {
    private static final L10N L = new L10N(EntityManagerProxy.class);
    private static final Logger log = Logger.getLogger(EntityManagerProxy.class.getName());
    private AmberPersistenceUnit _persistenceUnit;
    private boolean _isExtended;
    private Object _serializationHandle;

    public EntityManagerProxy(AmberPersistenceUnit persistenceUnit) {
        this._persistenceUnit = persistenceUnit;
    }

    public void persist(Object entity) {
        this.getCurrent().persist(entity);
    }

    public <T> T merge(T entity) {
        return this.getCurrent().merge(entity);
    }

    public void remove(Object entity) {
        this.getCurrent().remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.getCurrent().find(entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return this.getCurrent().getReference(entityClass, primaryKey);
    }

    public FlushModeType getFlushMode() {
        return this.getCurrent().getFlushMode();
    }

    public void setFlushMode(FlushModeType mode) {
        this.getCurrent().setFlushMode(mode);
    }

    public void setExtended(boolean isExtended) {
        this._isExtended = isExtended;
        this.getCurrent().setExtended(isExtended);
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getCurrent().lock(entity, lockMode);
    }

    public void clear() {
        this.getCurrent().clear();
    }

    public void flush() {
        this.getCurrent().flush();
    }

    public void joinTransaction() {
        throw new UnsupportedOperationException();
    }

    public Object getDelegate() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        throw new IllegalStateException(L.l("Container-manager persistence context may not be closed."));
    }

    public Query createQuery(String sql) {
        return this.getCurrent().createQuery(sql);
    }

    public Query createNamedQuery(String sql) {
        return this.getCurrent().createNamedQuery(sql);
    }

    public Query createNativeQuery(String sql) {
        return this.getCurrent().createNativeQuery(sql);
    }

    public Query createNativeQuery(String sql, String map) {
        return this.getCurrent().createNativeQuery(sql, map);
    }

    public Query createNativeQuery(String sql, Class retType) {
        return this.getCurrent().createNativeQuery(sql, retType);
    }

    public void refresh(Object entity) {
        this.getCurrent().refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.getCurrent().contains(entity);
    }

    public EntityTransaction getTransaction() {
        return this.getCurrent().getTransaction();
    }

    public boolean isOpen() {
        return true;
    }

    private AmberConnection getCurrent() {
        return this._persistenceUnit.getThreadConnection(this._isExtended);
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        AmberConnection aConn = this.getCurrent();
        if (aConn != null) {
            return "EntityManagerProxy[" + aConn.getPersistenceUnit().getName() + "]";
        }
        return "EntityManagerProxy[closed]";
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(String criteriaQuery, Class<T> resultClass) {
        return null;
    }

    public void detach(Object entity) {
    }

    public <T> T find(Class<T> entityCLass, Object primaryKey, Map<String, Object> properties) {
        return null;
    }

    public <T> T find(Class<T> entityCLass, Object primaryKey, LockModeType lockMode) {
        return null;
    }

    public <T> T find(Class<T> entityCLass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return null;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return null;
    }

    public LockModeType getLockMode(Object entity) {
        return null;
    }

    public Metamodel getMetamodel() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
    }

    public void refresh(Object entity, Map<String, Object> properties) {
    }

    public void refresh(Object entity, LockModeType lockMode) {
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
    }

    public void setProperty(String propertyName, Object value) {
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }
}

